package com.samsthenerd.monthofswords;

import com.google.common.base.Suppliers;
import com.samsthenerd.monthofswords.lucky.LuckyFunctions;
import com.samsthenerd.monthofswords.registry.*;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.registry.registries.RegistrarManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.function.Supplier;
import net.minecraft.class_1282;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_8103;

public final class SwordsMod {
    public static final String MOD_ID = "monthofswords";

    public static class_2960 id(String path){
        return class_2960.method_60655(MOD_ID, path);
    }

    public static final Supplier<RegistrarManager> MANAGER = Suppliers.memoize(() -> RegistrarManager.get(MOD_ID));

    public static final Logger LOGGER = LoggerFactory.getLogger(MOD_ID);

    public static void init() {
        SwordsModItems.register();
        SwordsModNetworking.commonInit();
        SwordsModLoot.init();
        SwordsModStatusEffects.init();
        SwordsModComponents.register();
        SwordsModDataLoaders.init();
        LuckyFunctions.register();

        EntityEvent.LIVING_HURT.register((class_1309 entity, class_1282 source, float amount) -> {
            class_1799 victimStack = entity.method_6047();
            if(entity instanceof class_1657 player
                && player.method_6115()
                && victimStack.method_7909().equals(SwordsModItems.DUELING_SWORD.get())
                && !source.method_48789(class_8103.field_43116)
                && !player.method_7357().method_7904(victimStack.method_7909())
            ){
                player.method_7357().method_7906(victimStack.method_7909(), 15);
                victimStack.method_7970(1, entity, class_1304.field_6173);
            }
            return EventResult.pass();
        });
    }
}
