/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.samsthenerd.inline.api.InlineAPI;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.api.matching.InlineMatcher;
import com.samsthenerd.inline.impl.InlineStyle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class InlineImpl
implements InlineAPI {
    private static final Map<ResourceLocation, InlineData.InlineDataType<?>> DATA_TYPES = new HashMap();
    private static final Codec<InlineData.InlineDataType<?>> INLINE_DATA_TYPE_CODEC = ResourceLocation.CODEC.comapFlatMap(id -> DATA_TYPES.containsKey(id) ? DataResult.success(DATA_TYPES.get(id)) : DataResult.error(() -> "No inline data type: " + id.toString()), InlineData.InlineDataType::getId);
    public static final Codec<InlineData<?>> INLINE_DATA_CODEC = INLINE_DATA_TYPE_CODEC.dispatch("type", InlineData::getType, inlineDataType -> inlineDataType.getCodec().fieldOf("data"));
    public static final Set<InlineMatcher> SERVER_CHAT_MATCHERS = new HashSet<InlineMatcher>();

    @Override
    public void addDataType(InlineData.InlineDataType<?> type) {
        DATA_TYPES.put(type.getId(), type);
    }

    @Override
    @Nullable
    public <D extends InlineData<D>> D deserializeData(JsonObject json) {
        String type = json.get("type").getAsString();
        if (!DATA_TYPES.containsKey(ResourceLocation.parse((String)type))) {
            return null;
        }
        InlineData.InlineDataType<?> dType = DATA_TYPES.get(ResourceLocation.parse((String)type));
        return (D)((InlineData)dType.getCodec().parse((DynamicOps)JsonOps.INSTANCE, (Object)json.get("data")).getOrThrow());
    }

    @Override
    public <D extends InlineData<D>> JsonObject serializeData(D data) {
        InlineData.InlineDataType<D> dType = data.getType();
        JsonObject json = new JsonObject();
        Optional dataElem = dType.getCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, data).result();
        json.addProperty("type", data.getType().toString());
        json.add("data", (JsonElement)dataElem.orElse(new JsonObject()));
        return json;
    }

    @Override
    public Style withSizeModifier(Style style, double modifier) {
        return style.withComponent(InlineStyle.SIZE_MODIFIER_COMP, (Object)modifier);
    }

    @Override
    public void addChatMatcher(InlineMatcher matcher) {
        SERVER_CHAT_MATCHERS.add(matcher);
    }
}

