/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.api.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.api.client.GlowHandling;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public interface InlineRenderer<D extends InlineData<D>> {
    public static final int DEFAULT_FONT_COLOR = 0xFFFFFF;
    public static final int DEFAULT_SHADOW_COLOR = 0x3E3E3E;

    public ResourceLocation getId();

    public int render(D var1, GuiGraphics var2, int var3, Style var4, int var5, TextRenderingContext var6);

    public int charWidth(D var1, Style var2, int var3);

    default public GlowHandling getGlowPreference(D forData) {
        return new GlowHandling.Full();
    }

    default public boolean handleOwnSizing(D forData) {
        return false;
    }

    default public boolean handleOwnTransparency(D forData) {
        return false;
    }

    public static boolean isFlat(PoseStack matrices, Font.DisplayMode layerType) {
        if (layerType == Font.DisplayMode.NORMAL) {
            Vector4f straightVec = new Vector4f(0.0f, 0.0f, 1.0f, 0.0f);
            straightVec.mul((Matrix4fc)matrices.last().pose());
            return straightVec.x() == 0.0f && straightVec.y() == 0.0f;
        }
        return false;
    }

    public static boolean isChatty() {
        return StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE).walk(s -> s.limit(20L).anyMatch(frame -> frame.getDeclaringClass().equals(ChatScreen.class) || frame.getDeclaringClass().equals(ChatComponent.class)));
    }

    public record TextRenderingContext(int light, boolean shadow, float brightnessMultiplier, float red, float green, float blue, float alpha, Font.DisplayMode layerType, MultiBufferSource vertexConsumers, boolean isGlowy, int outlineColor, int usableColor) {
    }
}

