package com.samsthenerd.inline.api.client.renderers;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.client.GlowHandling;
import com.samsthenerd.inline.api.client.InlineRenderer;
import com.samsthenerd.inline.api.data.ItemInlineData;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.CrashReportDetail;
import net.minecraft.ReportedException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.joml.Matrix4f;

public class InlineItemRenderer implements InlineRenderer<ItemInlineData>{

    public static final InlineItemRenderer INSTANCE = new InlineItemRenderer();

    public ResourceLocation getId(){
        return Inline.id( "item");
    }

    public static boolean debugEarlyReturn = true;

    public int render(ItemInlineData data, GuiGraphics context, int index, Style style, int codepoint, TextRenderingContext trContext){
        // only draw it once
        if(trContext.shadow()){
            return 8;
        }
        PoseStack matrices = context.pose();
        
        // context.drawItem(data.getStack(), 0, 0);
        // matrices.pop();

        ItemStack stack = data.getStack();
        Minecraft client = Minecraft.getInstance();
        Level world = client.level;

        if (stack.isEmpty()) {
            return 8;
        }
        BakedModel bakedModel = client.getItemRenderer().getModel(stack, world, null, 0);
        boolean flat = !bakedModel.usesBlockLight();
        /*
         * here we do a bunch of garbage to make lighting work as nicely as possible in-game.
         *
         * the main issue is that DiffuseLighting.disableGuiDepthLighting() messes up the game's lighting but is needed
         * to make an item look Right when rendered in a flat UI.
         *
         * First we check that it's flat and that the layer type is normal (all UI text rendering seems to use this?)
         * Then we check that the position matrix at the top is flat.
         */
        if (flat && InlineRenderer.isFlat(matrices, trContext.layerType())) {
            Lighting.setupForFlatItems();
        }
        matrices.pushPose();
        matrices.translate(4, 4, 0);
        try {
            matrices.mulPose(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
            matrices.scale(8.0f, 8.0f, 8f);
            client.getItemRenderer().render(stack, ItemDisplayContext.GUI, false, matrices, context.bufferSource(), trContext.light(), OverlayTexture.NO_OVERLAY, bakedModel);
            context.bufferSource().endBatch();
        } catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.forThrowable(throwable, "Rendering item");
            CrashReportCategory crashReportSection = crashReport.addCategory("Item being rendered");
            crashReportSection.setDetail("Item Type", (CrashReportDetail<String>)(() -> String.valueOf(stack.getItem())));
            crashReportSection.setDetail("Item Components", (CrashReportDetail<String>)(() -> String.valueOf(stack.getComponents())));
            crashReportSection.setDetail("Item Foil", (CrashReportDetail<String>)(() -> String.valueOf(stack.hasFoil())));
            throw new ReportedException(crashReport);
        }
        matrices.popPose();
        return 8;
    }

    public int charWidth(ItemInlineData data, Style style, int codepoint){
        return 8;
    }

    // TODO: handle animated items ehre
    @Override
    public GlowHandling getGlowPreference(ItemInlineData forData){
        // this nonsense should force it to refresh for animated sprites ?
        BakedModel bakedModel = Minecraft.getInstance().getItemRenderer().getModel(forData.getStack(), Minecraft.getInstance().level, null, 0);
        return new GlowHandling.Full(forData.getStack().getDescriptionId() + Integer.toHexString(bakedModel.hashCode()));
    }
}
