/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.tooltips;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class CustomTooltipManager {
    public static final Item HIJACKED_ITEM = Items.FEATHER;
    private static final String TOOLTIP_DATA_KEY = "inlinecustomtooltip";
    private static final Map<ResourceLocation, CustomTooltipProvider> PROVIDERS = new HashMap<ResourceLocation, CustomTooltipProvider>();
    private static final Codec<CustomTooltipProvider> PROVIDERS_CODEC = ResourceLocation.CODEC.comapFlatMap(DataResult.partialGet(PROVIDERS::get, () -> "Provider not found"), CustomTooltipProvider::getId);

    public static <T> ItemStack getForTooltip(CustomTooltipProvider<T> provider, T content) {
        ItemStack stack = new ItemStack((ItemLike)HIJACKED_ITEM);
        CTPData ctpd = new CTPData(provider, content);
        stack.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, tagComp -> (CustomData)tagComp.update((DynamicOps)NbtOps.INSTANCE, CTPData.CODEC, Optional.of(ctpd)).getOrThrow());
        return stack;
    }

    @Nullable
    public static CustomTooltipProvider<?> getProvider(ItemStack stack) {
        CustomData tagComp = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (tagComp == null) {
            return null;
        }
        try {
            return ((Optional)tagComp.read(CTPData.CODEC).getOrThrow()).map(CTPData::provider).orElse(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static List<Component> getTooltipText(ItemStack stack) {
        CustomData tagComp = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (tagComp == null) {
            return null;
        }
        try {
            return ((Optional)tagComp.read(CTPData.CODEC).getOrThrow()).map(ctpd -> ctpd.provider().getTooltipText(ctpd.data)).orElse(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Nullable
    public static <T> Optional<TooltipComponent> getTooltipData(ItemStack stack) {
        CustomData tagComp = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (tagComp == null) {
            return Optional.empty();
        }
        try {
            return ((Optional)tagComp.read(CTPData.CODEC).getOrThrow()).flatMap(ctpd -> ctpd.provider().getTooltipData(ctpd.data));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static <T> CustomTooltipProvider<T> registerProvider(CustomTooltipProvider<T> provider) {
        PROVIDERS.put(provider.getId(), provider);
        return provider;
    }

    public record CTPData<T>(CustomTooltipProvider<T> provider, T data) {
        public static final MapCodec<Optional<CTPData>> CODEC = PROVIDERS_CODEC.dispatch("inline_ctp_id", ctpd -> ctpd.provider(), CTPData::makeCTPDCodec).optionalFieldOf("inlinecustomtooltip");

        public static <T> MapCodec<CTPData<T>> makeCTPDCodec(CustomTooltipProvider<T> provider) {
            return provider.getCodec().fieldOf("inline_ctp_data").xmap(d -> new CTPData<Object>(provider, d), CTPData::data);
        }
    }

    public static interface CustomTooltipProvider<T> {
        public ResourceLocation getId();

        @NotNull
        public List<Component> getTooltipText(T var1);

        @NotNull
        public Optional<TooltipComponent> getTooltipData(T var1);

        @NotNull
        public Codec<T> getCodec();
    }
}

