/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.registry;

import com.samsthenerd.inline.tooltips.CustomTooltipManager;
import com.samsthenerd.inline.tooltips.components.EntityDisplayTTComp;
import com.samsthenerd.inline.tooltips.components.SpriteTooltipComponent;
import com.samsthenerd.inline.tooltips.data.EntityDisplayTTData;
import com.samsthenerd.inline.tooltips.data.SpriteTooltipData;
import com.samsthenerd.inline.tooltips.providers.EntityTTProvider;
import com.samsthenerd.inline.tooltips.providers.ModDataTTProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

public class InlineTooltips {
    public static final Map<Class<? extends TooltipComponent>, Function<TooltipComponent, ClientTooltipComponent>> tooltipDataToComponent = new HashMap<Class<? extends TooltipComponent>, Function<TooltipComponent, ClientTooltipComponent>>();

    public static ClientTooltipComponent getTooltipComponent(TooltipComponent data) {
        Function<TooltipComponent, ClientTooltipComponent> ttFunc = tooltipDataToComponent.get(data.getClass());
        return ttFunc == null ? null : ttFunc.apply(data);
    }

    public static <C extends ClientTooltipComponent, D extends TooltipComponent> Function<TooltipComponent, C> convertTooltip(Class<D> dataClass, Function<D, C> componentFactory) {
        return data -> {
            if (dataClass.isInstance(data)) {
                return (ClientTooltipComponent)componentFactory.apply((TooltipComponent)dataClass.cast(data));
            }
            return null;
        };
    }

    public static void init() {
        tooltipDataToComponent.put(SpriteTooltipData.class, InlineTooltips.convertTooltip(SpriteTooltipData.class, SpriteTooltipComponent::new));
        tooltipDataToComponent.put(EntityDisplayTTData.class, InlineTooltips.convertTooltip(EntityDisplayTTData.class, EntityDisplayTTComp::new));
        CustomTooltipManager.registerProvider(ModDataTTProvider.INSTANCE);
        CustomTooltipManager.registerProvider(EntityTTProvider.INSTANCE);
    }
}

