/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.api.matching;

import com.samsthenerd.inline.api.InlineAPI;
import com.samsthenerd.inline.api.matching.ContinuousMatcher;
import com.samsthenerd.inline.api.matching.InlineMatch;
import com.samsthenerd.inline.api.matching.MatchContext;
import com.samsthenerd.inline.api.matching.MatcherInfo;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public interface RegexMatcher
extends ContinuousMatcher {
    @Override
    default public ContinuousMatcher.ContinuousMatchResult match(String input, MatchContext matchContext) {
        Matcher regexMatcher = this.getRegex().matcher(input);
        ContinuousMatcher.ContinuousMatchResult result = new ContinuousMatcher.ContinuousMatchResult();
        while (regexMatcher.find()) {
            MatchResult mr = regexMatcher.toMatchResult();
            Tuple<InlineMatch, Integer> matchAndGroup = this.getMatchAndGroup(mr, matchContext);
            if (matchAndGroup.getA() == null) continue;
            result.addMatch(mr.start((Integer)matchAndGroup.getB()), mr.end((Integer)matchAndGroup.getB()), (InlineMatch)matchAndGroup.getA());
        }
        return result;
    }

    public Pattern getRegex();

    @NotNull
    default public Tuple<InlineMatch, Integer> getMatchAndGroup(MatchResult regexMatch, MatchContext matchContext) {
        return new Tuple((Object)this.getMatch(regexMatch, matchContext), (Object)0);
    }

    @Nullable
    public InlineMatch getMatch(MatchResult var1, MatchContext var2);

    public static class ChatStandard
    extends Standard {
        private BiFunction<String, MatchContext.ChatMatchContext, InlineMatch> ctxMatcher;

        public ChatStandard(String namespace, String innerRegex, ResourceLocation id, BiFunction<String, MatchContext.ChatMatchContext, InlineMatch> matcher, MatcherInfo info) {
            super(namespace, innerRegex, id, (String nop) -> null, info);
            this.ctxMatcher = matcher;
        }

        @Override
        public InlineMatch getMatch(MatchResult regexMatch, MatchContext matchContext) {
            if (!(matchContext instanceof MatchContext.ChatMatchContext)) {
                return null;
            }
            MatchContext.ChatMatchContext chatCtx = (MatchContext.ChatMatchContext)matchContext;
            InlineMatch retrievedMatch = this.ctxMatcher.apply(regexMatch.group(3), chatCtx);
            String separator = regexMatch.group(2);
            if (retrievedMatch instanceof InlineMatch.DataMatch) {
                InlineMatch.DataMatch dMatch = (InlineMatch.DataMatch)retrievedMatch;
                if (SEPARATOR_STYLES.containsKey(separator)) {
                    InlineMatch.DataMatch styledMatch = new InlineMatch.DataMatch(dMatch.data, (Style)((UnaryOperator)SEPARATOR_STYLES.get(separator)).apply(dMatch.style));
                    return styledMatch;
                }
            }
            return retrievedMatch;
        }
    }

    public static class Standard
    implements RegexMatcher {
        public static String IDENTIFIER_REGEX = "(?:[0-9a-z._-]+:)?[0-9a-z._\\/-]+";
        public static String IDENTIFIER_REGEX_INSENSITIVE = "(?:[0-9a-zA-Z._-]+:)?[0-9a-zA-Z._\\/-]+";
        public static String SEPARATORS_REGEX = "([:;,!+])";
        public static Map<String, UnaryOperator<Style>> SEPARATOR_STYLES = new HashMap<String, UnaryOperator<Style>>();
        private final Pattern regex;
        private final Function<String, InlineMatch> matcher;
        private final MatcherInfo info;
        private final ResourceLocation id;

        public Standard(String namespace, String innerRegex, ResourceLocation id, Function<String, InlineMatch> matcher, MatcherInfo info) {
            this.regex = Pattern.compile("(\\\\)?\\[(?i)(?:" + namespace + ")" + SEPARATORS_REGEX + "(" + innerRegex + ")\\]");
            this.id = id;
            this.info = info;
            this.matcher = matcher;
        }

        @Override
        public Pattern getRegex() {
            return this.regex;
        }

        @Override
        public InlineMatch getMatch(MatchResult regexMatch, MatchContext matchContext) {
            InlineMatch retrievedMatch = this.matcher.apply(regexMatch.group(3));
            String separator = regexMatch.group(2);
            if (retrievedMatch instanceof InlineMatch.DataMatch) {
                InlineMatch.DataMatch dMatch = (InlineMatch.DataMatch)retrievedMatch;
                if (SEPARATOR_STYLES.containsKey(separator)) {
                    InlineMatch.DataMatch styledMatch = new InlineMatch.DataMatch(dMatch.data, (Style)SEPARATOR_STYLES.get(separator).apply(dMatch.style));
                    return styledMatch;
                }
            }
            return retrievedMatch;
        }

        @Override
        @NotNull
        public Tuple<InlineMatch, Integer> getMatchAndGroup(MatchResult regexMatch, MatchContext matchContext) {
            if (regexMatch.group(1) != null) {
                return new Tuple((Object)new InlineMatch.TextMatch((Component)Component.literal((String)"")), (Object)1);
            }
            return new Tuple((Object)this.getMatch(regexMatch, matchContext), (Object)0);
        }

        @Override
        public MatcherInfo getInfo() {
            return this.info;
        }

        @Override
        public ResourceLocation getId() {
            return this.id;
        }

        static {
            SEPARATOR_STYLES.put("!", sty -> InlineAPI.INSTANCE.withSizeModifier((Style)sty, 1.5));
            SEPARATOR_STYLES.put("+", sty -> InlineAPI.INSTANCE.withSizeModifier((Style)sty, 2.0));
            SEPARATOR_STYLES.put(",", sty -> InlineAPI.INSTANCE.withSizeModifier((Style)sty, 0.75));
        }
    }

    public static class Simple
    implements RegexMatcher {
        private Pattern regex;
        private Function<MatchResult, InlineMatch> matcher;
        private MatcherInfo info;
        private ResourceLocation id;

        public Simple(Pattern regex, ResourceLocation id, Function<MatchResult, InlineMatch> matcher, MatcherInfo info) {
            this.regex = regex;
            this.matcher = matcher;
            this.info = info;
            this.id = id;
        }

        public Simple(String regex, ResourceLocation id, Function<MatchResult, InlineMatch> matcher, MatcherInfo info) {
            this(Pattern.compile(regex), id, matcher, info);
        }

        @Override
        public Pattern getRegex() {
            return this.regex;
        }

        @Override
        public InlineMatch getMatch(MatchResult regexMatch, MatchContext matchContext) {
            return this.matcher.apply(regexMatch);
        }

        @Override
        public MatcherInfo getInfo() {
            return this.info;
        }

        @Override
        public ResourceLocation getId() {
            return this.id;
        }
    }
}

