package com.samsthenerd.inline.utils;

import com.samsthenerd.inline.mixin.feature.playerskins.MixinAccessPlayerModelParts;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.ResolvableProfile;

public class FakeClientPlayerMaker {
    public static Entity getPlayerEntity(ResolvableProfile profile) {
        var profFuture = profile.resolve();
        var profileToUse = profile;
        try{
            if(profFuture.isDone()) profileToUse = profFuture.get();
        } catch (Exception ignored){}

        Player player = new RemotePlayer(Minecraft.getInstance().level, profileToUse.gameProfile()) {
            @Override
            public boolean shouldShowName() {
                return false;
            }

            @Override
            public PlayerSkin getSkin(){
                return Minecraft.getInstance().getSkinManager().getInsecureSkin(this.getGameProfile());
            }
        };
        player.yCloakO = player.yCloak = (player.getY() - 0.5);
        player.xCloakO = player.xCloak = player.getX();
        player.zCloakO = player.zCloak = player.getZ();
        player.getEntityData().set(MixinAccessPlayerModelParts.getPlayerModelParts(), (byte) 0b11111111);
        return player;
    }
}
