/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline;

import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.client.InlineClientAPI;
import com.samsthenerd.inline.api.client.renderers.InlineEntityRenderer;
import com.samsthenerd.inline.api.client.renderers.InlineItemRenderer;
import com.samsthenerd.inline.api.client.renderers.InlineSpriteRenderer;
import com.samsthenerd.inline.api.client.renderers.PlayerHeadRenderer;
import com.samsthenerd.inline.api.data.EntityInlineData;
import com.samsthenerd.inline.api.data.ItemInlineData;
import com.samsthenerd.inline.api.data.ModIconData;
import com.samsthenerd.inline.api.data.PlayerHeadData;
import com.samsthenerd.inline.api.data.SpriteInlineData;
import com.samsthenerd.inline.api.matching.InlineMatch;
import com.samsthenerd.inline.api.matching.MatcherInfo;
import com.samsthenerd.inline.api.matching.RegexMatcher;
import com.samsthenerd.inline.impl.ProfileComponentUtil;
import com.samsthenerd.inline.utils.URLSprite;
import com.samsthenerd.inline.xplat.IModMeta;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.ItemLike;

public class InlineClient {
    public static void initClient() {
        InlineClient.addDefaultRenderers();
        InlineClient.addDefaultMatchers();
        InlineClient.addExtraHookTests();
    }

    private static void addDefaultRenderers() {
        InlineClientAPI.INSTANCE.addRenderer(InlineItemRenderer.INSTANCE);
        InlineClientAPI.INSTANCE.addRenderer(InlineEntityRenderer.INSTANCE);
        InlineClientAPI.INSTANCE.addRenderer(InlineSpriteRenderer.INSTANCE);
        InlineClientAPI.INSTANCE.addRenderer(PlayerHeadRenderer.INSTANCE);
    }

    private static void addDefaultMatchers() {
        ResourceLocation itemMatcherID = Inline.id("item");
        InlineClientAPI.INSTANCE.addMatcher(new RegexMatcher.Standard("item", RegexMatcher.Standard.IDENTIFIER_REGEX_INSENSITIVE, itemMatcherID, itemId -> {
            ResourceLocation itemActualId = ResourceLocation.parse((String)itemId.toLowerCase());
            if (!BuiltInRegistries.ITEM.containsKey(itemActualId)) {
                return null;
            }
            Item item = (Item)BuiltInRegistries.ITEM.get(itemActualId);
            ItemStack stack = new ItemStack((ItemLike)item);
            HoverEvent he = new HoverEvent(HoverEvent.Action.SHOW_ITEM, (Object)new HoverEvent.ItemStackInfo(stack));
            return new InlineMatch.DataMatch(new ItemInlineData(stack), Style.EMPTY.withHoverEvent(he));
        }, MatcherInfo.fromId(itemMatcherID)));
        ResourceLocation entityMatcherID = Inline.id("entity");
        InlineClientAPI.INSTANCE.addMatcher(new RegexMatcher.Standard("entity", RegexMatcher.Standard.IDENTIFIER_REGEX_INSENSITIVE, entityMatcherID, entityTypeId -> {
            ResourceLocation entTypeActualId = ResourceLocation.parse((String)entityTypeId.toLowerCase());
            if (!BuiltInRegistries.ENTITY_TYPE.containsKey(entTypeActualId)) {
                return null;
            }
            EntityType entType = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(entTypeActualId);
            EntityInlineData entData = EntityInlineData.fromType(entType);
            return new InlineMatch.DataMatch(entData, Style.EMPTY.withHoverEvent(entData.getEntityDisplayHoverEvent()));
        }, MatcherInfo.fromId(entityMatcherID)));
        ResourceLocation imgMatcherId = Inline.id("imgtest");
        InlineClientAPI.INSTANCE.addMatcher(new RegexMatcher.Standard("img", "[^\\[\\]]+", imgMatcherId, url -> {
            String urlId = url.chars().mapToObj(ch -> Character.valueOf((char)ch)).filter(c -> c.charValue() != ':' && ResourceLocation.isAllowedInResourceLocation((char)c.charValue())).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
            return new InlineMatch.DataMatch(new SpriteInlineData(new URLSprite((String)url, ResourceLocation.parse((String)urlId))));
        }, MatcherInfo.fromId(imgMatcherId)));
        ResourceLocation modMatcherId = Inline.id("modicon");
        InlineClientAPI.INSTANCE.addMatcher(new RegexMatcher.Standard("mod", "[0-9A-Za-z._-]+", modMatcherId, modid -> {
            String modidLowercase = modid.toLowerCase();
            Optional<IModMeta> maybeMod = IModMeta.getMod(modidLowercase);
            if (maybeMod.isEmpty()) {
                return null;
            }
            return new InlineMatch.DataMatch(new ModIconData(modidLowercase), ModIconData.getTooltipStyle(modidLowercase));
        }, MatcherInfo.fromId(modMatcherId)));
        ResourceLocation faceMatcherId = Inline.id("playerface");
        InlineClientAPI.INSTANCE.addMatcher(new RegexMatcher.Standard("face", "[a-zA-Z0-9_]{1,16}|[a-f0-9]{8}(?:-[a-f0-9]{4}){4}[a-f0-9]{8}", faceMatcherId, playerNameOrUUID -> {
            ResolvableProfile profile = playerNameOrUUID.length() > 16 ? ProfileComponentUtil.from(UUID.fromString(playerNameOrUUID), null) : ProfileComponentUtil.from(null, playerNameOrUUID);
            PlayerHeadData headData = new PlayerHeadData(profile);
            return new InlineMatch.DataMatch(headData, Style.EMPTY.withHoverEvent(headData.getEntityDisplayHoverEvent()));
        }, MatcherInfo.fromId(faceMatcherId)));
    }

    private static void addExtraHookTests() {
    }
}

