package com.samsthenerd.inline.mixin.feature.playerskins;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

@Mixin(LivingEntityRenderer.class)
public class MixinTurnOffLabel {
    @ModifyReturnValue(
        method = "hasLabel(Lnet/minecraft/entity/LivingEntity;)Z",
        at = @At("RETURN")
    )
    private boolean killPlayerLabel(boolean original, LivingEntity entity){
        if(!original) return original;
        if(entity instanceof Player otherPlayer){
            return otherPlayer.shouldShowName();
        }
        return original;
    }
}
