package com.samsthenerd.inline;

import com.samsthenerd.inline.api.InlineAPI;
import com.samsthenerd.inline.api.data.EntityInlineData.EntityDataType;
import com.samsthenerd.inline.api.data.ItemInlineData;
import com.samsthenerd.inline.api.data.ItemInlineData.ItemDataType;
import com.samsthenerd.inline.api.data.ModIconData.ModIconDataType;
import com.samsthenerd.inline.api.data.PlayerHeadData.PlayerHeadDataType;
import com.samsthenerd.inline.api.data.SpriteInlineData.SpriteDataType;
import com.samsthenerd.inline.api.matching.InlineMatch;
import com.samsthenerd.inline.api.matching.MatcherInfo;
import com.samsthenerd.inline.api.matching.RegexMatcher;
import com.samsthenerd.inline.api.matching.RegexMatcher.Standard;
import com.samsthenerd.inline.xplat.XPlatInstances;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

// this will probably be bumped out into its own mod Soon, but i want to get it working in this test environment first
public class Inline {

    public static final String MOD_ID = "inline";

    public static final Logger LOGGER = LoggerFactory.getLogger("inline");

    public static ResourceLocation id(String path){
        return ResourceLocation.fromNamespaceAndPath(MOD_ID, path);
    }

    public static XPlatInstances getXPlats(){
        return xPlats;
    }

	public static final void logPrint(String message){
        // if(IXPlatAbstractions.getInstance().isDevEnv())
			LOGGER.info(message);
	}

    private static XPlatInstances xPlats;

    public static void onInitialize(XPlatInstances xPlats){
        // nothing yet !
        Inline.xPlats = xPlats;
        registerDataTypes();
        addChatMatchers();
    }

    private static void registerDataTypes(){
        InlineAPI.INSTANCE.addDataType(EntityDataType.INSTANCE);
        InlineAPI.INSTANCE.addDataType(ItemDataType.INSTANCE);
        InlineAPI.INSTANCE.addDataType(ModIconDataType.INSTANCE);
        InlineAPI.INSTANCE.addDataType(PlayerHeadDataType.INSTANCE);
        InlineAPI.INSTANCE.addDataType(SpriteDataType.INSTANCE);
    }

    private static final Map<String, String> EQUIPMENT_ALIASES = Map.of(
        "hand", "mainhand", "chestplate", "chest", "leggings", "legs", "helmet", "head",
        "boots", "feet", "shoes", "feet"
    );
    private static void addChatMatchers(){
        ResourceLocation showOffID = ResourceLocation.fromNamespaceAndPath(Inline.MOD_ID, "showoff");
        RegexMatcher showOffMatcher = new RegexMatcher.ChatStandard("show", Standard.IDENTIFIER_REGEX_INSENSITIVE, showOffID,
                (whatToShow, ctx) -> {
                    ItemStack stack = null;
                    whatToShow = EQUIPMENT_ALIASES.getOrDefault(whatToShow, whatToShow);
                    try{
                        stack = ctx.getChatSender().getItemBySlot(EquipmentSlot.byName(whatToShow));
                    } catch (Exception e){}
                    if(stack == null || stack.isEmpty()){
                        stack = new ItemStack(Items.BARRIER);
                        stack.set(DataComponents.CUSTOM_NAME, Component.translatable("ui.inline.nothingtoshowoff"));
                    }
                    HoverEvent he = new HoverEvent(HoverEvent.Action.SHOW_ITEM, new HoverEvent.ItemStackInfo(stack));
                    return new InlineMatch.DataMatch(new ItemInlineData(stack), Style.EMPTY.withHoverEvent(he));
                },
                MatcherInfo.fromId(showOffID)
        );
        InlineAPI.INSTANCE.addChatMatcher(showOffMatcher);
    }
}
