/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.utils;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.mixin.core.NativeImageAccessor;
import com.samsthenerd.inline.utils.IntPair;
import com.samsthenerd.inline.utils.SpriteUVLens;
import com.samsthenerd.inline.utils.SpriteUVRegion;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import org.lwjgl.PointerBuffer;
import org.lwjgl.nanovg.NSVGImage;
import org.lwjgl.nanovg.NanoSVG;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class URLTextureUtils {
    private static final Map<ResourceLocation, ResourceLocation> LOADED_TEXTURES = Collections.synchronizedMap(new HashMap());
    private static final Map<ResourceLocation, Tuple<IntPair, SpriteUVLens>> TEXTURE_INFO = Collections.synchronizedMap(new HashMap());
    private static final Set<ResourceLocation> IN_PROGRESS_TEXTURES = Collections.synchronizedSet(new HashSet());

    @Nullable
    public static ResourceLocation loadTextureFromURL(String urlStr, ResourceLocation textureId) {
        ResourceLocation maybeTexture = LOADED_TEXTURES.get(textureId);
        if (maybeTexture != null) {
            return maybeTexture;
        }
        if (IN_PROGRESS_TEXTURES.contains(textureId)) {
            return null;
        }
        IN_PROGRESS_TEXTURES.add(textureId);
        CompletableFuture.runAsync(() -> {
            try {
                URL textureUrl = URI.create(urlStr).toURL();
                URLConnection conn = textureUrl.openConnection();
                InputStream stream = conn.getInputStream();
                String contentType = URLConnection.guessContentTypeFromStream(stream);
                if (contentType == null) {
                    contentType = conn.getContentType();
                }
                String selector0$temp = contentType;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{"image/png", "image/gif", "image/svg+xml"}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        NativeImage baseImage = NativeImage.read((InputStream)stream);
                        Minecraft.getInstance().execute(() -> {
                            DynamicTexture texture = new DynamicTexture(baseImage);
                            Minecraft.getInstance().getTextureManager().register(textureId, (AbstractTexture)texture);
                            LOADED_TEXTURES.put(textureId, textureId);
                            TEXTURE_INFO.put(textureId, (Tuple<IntPair, SpriteUVLens>)new Tuple((Object)new IntPair(baseImage.getWidth(), baseImage.getHeight()), (Object)SpriteUVRegion.FULL.asLens()));
                            IN_PROGRESS_TEXTURES.remove(textureId);
                        });
                        break;
                    }
                    case 1: {
                        ByteBuffer byBuf = TextureUtil.readResource((InputStream)conn.getInputStream());
                        byBuf.rewind();
                        URLTextureUtils.readGif(textureId, byBuf);
                        break;
                    }
                    case 2: {
                        ByteBuffer byBuf = TextureUtil.readResource((InputStream)conn.getInputStream());
                        byBuf.rewind();
                        URLTextureUtils.readSVG(textureId, byBuf, (w, h) -> {
                            float scale = Math.min(256.0f / w.floatValue(), 256.0f / h.floatValue());
                            return Math.round(w.floatValue() * scale);
                        });
                        break;
                    }
                    default: {
                        try {
                            ByteBuffer byBuf = TextureUtil.readResource((InputStream)conn.getInputStream());
                            byBuf.rewind();
                            URLTextureUtils.readImageSTB(textureId, byBuf);
                        }
                        catch (Exception e) {
                            Inline.LOGGER.error("Unable to load image at URL:" + String.valueOf(textureUrl) + "\n\tLikely an unknown image type \"" + contentType + "\"");
                        }
                        break;
                    }
                }
            }
            catch (Exception e) {
                Inline.LOGGER.error("Failed to load texture from URL: " + urlStr + "\n:" + String.valueOf(e));
            }
        });
        return null;
    }

    @Nullable
    public static Tuple<IntPair, SpriteUVLens> getTextureInfo(ResourceLocation textureId) {
        return TEXTURE_INFO.get(textureId);
    }

    public static Tuple<IntPair, SpriteUVLens> readGif(ResourceLocation loc, ByteBuffer buf) throws IOException {
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            PointerBuffer delayBuf = memoryStack.mallocPointer(1);
            IntBuffer wBuf = memoryStack.mallocInt(1);
            IntBuffer hBuf = memoryStack.mallocInt(1);
            IntBuffer framesBuf = memoryStack.mallocInt(1);
            IntBuffer channelsBuf = memoryStack.mallocInt(1);
            ByteBuffer imageBuf = STBImage.stbi_load_gif_from_memory((ByteBuffer)buf, (PointerBuffer)delayBuf, (IntBuffer)wBuf, (IntBuffer)hBuf, (IntBuffer)framesBuf, (IntBuffer)channelsBuf, (int)4);
            if (imageBuf == null) {
                throw new IOException("Could not load image here: " + STBImage.stbi_failure_reason());
            }
            NativeImage image = new NativeImage(wBuf.get(0), hBuf.get(0) * framesBuf.get(0), true);
            MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)imageBuf), (long)((NativeImageAccessor)image).getPixels(), (long)((long)wBuf.get(0) * (long)hBuf.get(0) * (long)framesBuf.get(0) * 4L));
            DynamicTexture tex = new DynamicTexture(image);
            int[] delays = new int[framesBuf.get(0)];
            delayBuf.getIntBuffer(framesBuf.get(0)).get(delays);
            Tuple textInfo = new Tuple((Object)new IntPair(wBuf.get(0), hBuf.get(0) * framesBuf.get(0)), (Object)new SpriteUVLens.AnimUVLens(1.0 / (double)framesBuf.get(0), true, delays));
            Minecraft.getInstance().execute(() -> {
                Minecraft.getInstance().getTextureManager().register(loc, (AbstractTexture)tex);
                LOADED_TEXTURES.put(loc, loc);
                TEXTURE_INFO.put(loc, (Tuple<IntPair, SpriteUVLens>)textInfo);
                IN_PROGRESS_TEXTURES.remove(loc);
            });
            Tuple tuple = textInfo;
            return tuple;
        }
    }

    public static Tuple<IntPair, SpriteUVLens> readImageSTB(ResourceLocation loc, ByteBuffer buf) throws IOException {
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            IntBuffer wBuf = memoryStack.mallocInt(1);
            IntBuffer hBuf = memoryStack.mallocInt(1);
            IntBuffer channelsBuf = memoryStack.mallocInt(1);
            ByteBuffer imageBuf = STBImage.stbi_load_from_memory((ByteBuffer)buf, (IntBuffer)wBuf, (IntBuffer)hBuf, (IntBuffer)channelsBuf, (int)4);
            if (imageBuf == null) {
                throw new IOException("Could not load image here: " + STBImage.stbi_failure_reason());
            }
            NativeImage image = new NativeImage(wBuf.get(0), hBuf.get(0), true);
            MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)imageBuf), (long)((NativeImageAccessor)image).getPixels(), (long)((long)wBuf.get(0) * (long)hBuf.get(0) * 4L));
            DynamicTexture tex = new DynamicTexture(image);
            Tuple textInfo = new Tuple((Object)new IntPair(wBuf.get(0), hBuf.get(0)), (Object)SpriteUVRegion.FULL.asLens());
            Minecraft.getInstance().execute(() -> {
                Minecraft.getInstance().getTextureManager().register(loc, (AbstractTexture)tex);
                LOADED_TEXTURES.put(loc, loc);
                TEXTURE_INFO.put(loc, (Tuple<IntPair, SpriteUVLens>)textInfo);
                IN_PROGRESS_TEXTURES.remove(loc);
            });
            Tuple tuple = textInfo;
            return tuple;
        }
    }

    public static Tuple<IntPair, SpriteUVLens> readSVG(ResourceLocation loc, ByteBuffer svgXmlBuf, BiFunction<Float, Float, Integer> sizeFunc) {
        Tuple tuple;
        block9: {
            MemoryStack stack = MemoryStack.stackPush();
            try {
                NSVGImage svg = NanoSVG.nsvgParse((ByteBuffer)svgXmlBuf, (ByteBuffer)stack.ASCII((CharSequence)"px"), (float)96.0f);
                if (svg == null) {
                    throw new IllegalStateException("Failed to parse SVG.");
                }
                long rast = NanoSVG.nsvgCreateRasterizer();
                int width = sizeFunc.apply(Float.valueOf(svg.width()), Float.valueOf(svg.height()));
                float scale = (float)width / svg.width();
                int height = Math.round(svg.height() * scale);
                ByteBuffer svgRast = MemoryUtil.memAlloc((int)(width * height * 4));
                NanoSVG.nsvgRasterize((long)rast, (NSVGImage)svg, (float)0.0f, (float)0.0f, (float)scale, (ByteBuffer)svgRast, (int)width, (int)height, (int)(width * 4));
                NanoSVG.nsvgDeleteRasterizer((long)rast);
                NativeImage image = new NativeImage(width, height, true);
                MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)svgRast), (long)((NativeImageAccessor)image).getPixels(), (long)((long)width * (long)height * 4L));
                DynamicTexture tex = new DynamicTexture(image);
                Tuple textInfo = new Tuple((Object)new IntPair(width, height), (Object)SpriteUVRegion.FULL.asLens());
                Minecraft.getInstance().execute(() -> {
                    Minecraft.getInstance().getTextureManager().register(loc, (AbstractTexture)tex);
                    LOADED_TEXTURES.put(loc, loc);
                    TEXTURE_INFO.put(loc, (Tuple<IntPair, SpriteUVLens>)textInfo);
                    IN_PROGRESS_TEXTURES.remove(loc);
                });
                tuple = textInfo;
                if (stack == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (stack != null) {
                        try {
                            stack.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    Inline.LOGGER.error(e.toString());
                    throw e;
                }
            }
            stack.close();
        }
        return tuple;
    }
}

