/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.neoforge;

import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.InlineClient;
import com.samsthenerd.inline.api.matching.InlineMatcher;
import com.samsthenerd.inline.api.matching.MatchContext;
import com.samsthenerd.inline.config.InlineConfigHandler;
import com.samsthenerd.inline.impl.InlineImpl;
import com.samsthenerd.inline.neoforge.xplat.ForgeAbstractions;
import com.samsthenerd.inline.neoforge.xplat.ForgeModMeta;
import com.samsthenerd.inline.xplat.XPlatInstances;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModLoadingContext;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.ServerChatEvent;

@Mod(value="inline")
public class InlineForge {
    public InlineForge() {
        ModContainer modContainer = ModLoadingContext.get().getActiveContainer();
        IEventBus modBus = ModLoadingContext.get().getActiveContainer().getEventBus();
        modBus.addListener(this::onClientSetup);
        NeoForge.EVENT_BUS.addListener(this::onServerChatDecoration);
        modContainer.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)(mc, parent) -> InlineConfigHandler.getConfigScreen(parent)));
        XPlatInstances forgeXPlats = new XPlatInstances(ForgeModMeta::getMod, new ForgeAbstractions());
        Inline.onInitialize(forgeXPlats);
    }

    private void onClientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> InlineClient.initClient());
    }

    private void onServerChatDecoration(ServerChatEvent event) {
        MatchContext.ChatMatchContext ctx = MatchContext.ChatMatchContext.of(event.getPlayer(), event.getMessage());
        for (InlineMatcher matcher : InlineImpl.SERVER_CHAT_MATCHERS) {
            matcher.match(ctx);
        }
        event.setMessage(ctx.getFinalStyledText());
    }
}

