/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.tooltips.providers;

import com.mojang.serialization.Codec;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.tooltips.CustomTooltipManager;
import com.samsthenerd.inline.tooltips.data.EntityDisplayTTData;
import com.samsthenerd.inline.utils.EntityCradle;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class EntityTTProvider
implements CustomTooltipManager.CustomTooltipProvider<EntityCradle> {
    public static final EntityTTProvider INSTANCE = new EntityTTProvider();

    @Override
    public ResourceLocation getId() {
        return Inline.id("entitydisplay");
    }

    @Override
    @NotNull
    public List<Component> getTooltipText(EntityCradle cradle) {
        ArrayList<Component> ttText = new ArrayList<Component>();
        Entity ent = cradle.getEntity((Level)Minecraft.getInstance().level);
        if (ent != null) {
            ttText.add(ent.getName());
        }
        return ttText;
    }

    @Override
    @NotNull
    public Optional<TooltipComponent> getTooltipData(EntityCradle cradle) {
        return Optional.of(new EntityDisplayTTData(cradle, (w, h) -> h == 0 ? 0 : Math.min(w * 96 / h, 96)));
    }

    @Override
    public Codec<EntityCradle> getCodec() {
        return EntityCradle.CRADLE_CODEC;
    }
}

