package com.samsthenerd.inline.api.matching;

import java.util.ArrayList;
import java.util.List;
import java.util.Map.Entry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Tuple;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.api.matching.InlineMatch.DataMatch;
import com.samsthenerd.inline.api.matching.InlineMatch.TextMatch;

public interface ContinuousMatcher extends InlineMatcher{

    ContinuousMatchResult match(String input, MatchContext matchContext);

    default void match(MatchContext matchContext){
        for(Entry<Integer, String> seqEntry : matchContext.getUnmatchedSequences().entrySet()){
            ContinuousMatchResult res = match(seqEntry.getValue(), matchContext);
            for(Tuple<Tuple<Integer, Integer>, InlineMatch> match : res.getMatches()){
                int matchStart = match.getA().getA() + seqEntry.getKey();
                int matchEnd = match.getA().getB() + seqEntry.getKey();
                matchContext.addMatch(matchStart, matchEnd, match.getB());
            }
        }
    }

    class ContinuousMatchResult {
        
        // Horrible generic, but whatever, consider it an implementation detail
        private List<Tuple<Tuple<Integer, Integer>, InlineMatch>> matches = new ArrayList<>();

        public ContinuousMatchResult addMatch(int start, int end, InlineData data){
            return addMatch(start, end, data, Style.EMPTY);
        }
        
        public ContinuousMatchResult addMatch(int start, int end, Component text){
            return addMatch(start, end, new TextMatch(text));
        }

        public ContinuousMatchResult addMatch(int start, int end, InlineData data, Style style){
            return addMatch(start, end, new DataMatch(data, style));
        }

        public ContinuousMatchResult addMatch(int start, int end, InlineMatch match){
            // TODO: add conflict detection here ?
            matches.add(new Tuple<>(new Tuple<>(start, end), match));
            return this;
        }

        public List<Tuple<Tuple<Integer, Integer>, InlineMatch>> getMatches(){
            return new ArrayList<>(matches);
        }    
    }
}
