/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.utils;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.samsthenerd.inline.utils.IntPair;
import com.samsthenerd.inline.utils.SpriteUVLens;
import com.samsthenerd.inline.utils.SpriteUVRegion;
import com.samsthenerd.inline.utils.Spritelike;
import com.samsthenerd.inline.utils.URLTextureUtils;
import java.util.Objects;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public class URLSprite
extends Spritelike {
    private final String url;
    private final ResourceLocation id;
    @NotNull
    private final UnaryOperator<SpriteUVLens> lensModifier;
    @Nullable
    private IntPair textDims;
    @Nullable
    private SpriteUVLens lens;
    @Nullable
    private ResourceLocation textureID;

    public URLSprite(String url, ResourceLocation id) {
        this(url, id, UnaryOperator.identity());
    }

    public URLSprite(String url, ResourceLocation id, UnaryOperator<SpriteUVLens> lensModifier) {
        this.url = url;
        this.id = id;
        this.lensModifier = lensModifier;
    }

    @Override
    public Spritelike.SpritelikeType getType() {
        return UrlSpriteType.INSTANCE;
    }

    @Override
    public ResourceLocation getTextureId() {
        return URLTextureUtils.loadTextureFromURL(this.url, this.id);
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    private IntPair getOrFetchDims() {
        if (this.textDims != null) {
            return this.textDims;
        }
        Tuple<IntPair, SpriteUVLens> newTextInfo = URLTextureUtils.getTextureInfo(this.id);
        if (newTextInfo != null) {
            this.textDims = (IntPair)newTextInfo.getA();
        }
        return this.textDims;
    }

    private SpriteUVLens getOrFetchLens() {
        if (this.lens != null) {
            return this.lens;
        }
        Tuple<IntPair, SpriteUVLens> newTextInfo = URLTextureUtils.getTextureInfo(this.id);
        if (newTextInfo != null) {
            this.lens = (SpriteUVLens)this.lensModifier.apply((SpriteUVLens)newTextInfo.getB());
        }
        return this.lens;
    }

    @Override
    public int getTextureWidth() {
        return Objects.requireNonNullElse(this.getOrFetchDims(), new IntPair(0, 0)).width();
    }

    @Override
    public int getTextureHeight() {
        return Objects.requireNonNullElse(this.getOrFetchDims(), new IntPair(0, 0)).height();
    }

    @Override
    public SpriteUVRegion getUVs(long time) {
        return Objects.requireNonNullElse(this.getOrFetchLens(), SpriteUVLens::identity).genUVs(time);
    }

    public static class UrlSpriteType
    implements Spritelike.SpritelikeType {
        public static final UrlSpriteType INSTANCE = new UrlSpriteType();
        private static final MapCodec<URLSprite> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.STRING.fieldOf("url").forGetter(URLSprite::getUrl), (App)ResourceLocation.CODEC.fieldOf("id").forGetter(URLSprite::getId)).apply((Applicative)instance, URLSprite::new));

        public MapCodec<URLSprite> getCodec() {
            return CODEC;
        }

        @Override
        public String getId() {
            return "url";
        }
    }
}

