package com.samsthenerd.inline.tooltips.data;

import com.samsthenerd.inline.utils.Spritelike;
import java.util.function.BiFunction;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

// maxWidth/maxHeight are for how big it should render
public class SpriteTooltipData implements TooltipComponent {
    public final Spritelike sprite;
    // takes in the  width and height of the given texture and returns the width to render it at
    public BiFunction<Integer, Integer, Integer> widthProvider = (w, h) -> 128;

    public SpriteTooltipData(Spritelike sprite){
        this.sprite = sprite;
    }

    public SpriteTooltipData(Spritelike sprite, BiFunction<Integer, Integer, Integer> widthProvider){
        this.sprite = sprite;
        this.widthProvider = widthProvider;
    }
}
