package com.samsthenerd.inline.impl.extrahooks;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.samsthenerd.inline.api.client.extrahooks.ItemOverlayRenderer;
import com.samsthenerd.inline.utils.VCPImmediateButImLyingAboutIt;
import java.util.*;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class ItemOverlayManager {
    private static final Map<Item, List<ItemOverlayRenderer>> ITEM_RENDERERS = new HashMap<>();
    private static final Set<ItemOverlayRenderer> GLOBAL_RENDERERS = new HashSet<>();

    public static List<ItemOverlayRenderer> getRenderers(Item item){
        var renderers = new ArrayList<>(ITEM_RENDERERS.getOrDefault(item, List.of()));
        renderers.addAll(GLOBAL_RENDERERS);
        return renderers;
    }

    public static void addRenderer(Item item, ItemOverlayRenderer renderer){
        ITEM_RENDERERS.computeIfAbsent(item, it -> new ArrayList<>()).add(renderer);
    }

    public static void addRenderer(ItemOverlayRenderer renderer){
        GLOBAL_RENDERERS.add(renderer);
    }

    public static void removeRenderer(ItemOverlayRenderer renderer){
        GLOBAL_RENDERERS.remove(renderer);
    }

    public static void renderDetailTexture(ItemStack stack, PoseStack matrices,
                                           ItemDisplayContext renderMode, MultiBufferSource vertexConsumers,
                                           int light, int overlay, boolean leftHanded){
        if(renderMode != ItemDisplayContext.GUI) return;
        var renderers = ItemOverlayManager.getRenderers(stack.getItem());
        for(var overlayRenderer : renderers) {

            if(!overlayRenderer.isActive(stack)) continue;

            boolean overItem = overlayRenderer.renderInFront(stack);
            MultiBufferSource.BufferSource immVC;
            if (overItem && vertexConsumers instanceof MultiBufferSource.BufferSource immediateVCs) {
                RenderSystem.disableDepthTest();
                immediateVCs.endBatch();
                RenderSystem.enableDepthTest();
                immVC = immediateVCs;
            } else {
                immVC = VCPImmediateButImLyingAboutIt.of(vertexConsumers);
            }

            GuiGraphics drawCtx = new GuiGraphics(Minecraft.getInstance(), immVC);
            PoseStack ctxMat = drawCtx.pose();
            ctxMat.pushPose();
            ctxMat.mulPose(matrices.last().pose());
            ctxMat.scale(1f/16, -1f/16, 1f/16);
            ctxMat.translate(0, -16, overItem ? 10 : -100);
            overlayRenderer.render(stack, drawCtx);
            ctxMat.popPose();
        }
    }
}
