package com.samsthenerd.inline.api.data;

import com.mojang.serialization.Codec;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.impl.InlineStyle;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.HoverEvent.ItemStackInfo;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;

public class ItemInlineData implements InlineData<ItemInlineData>{

    private ItemStack stack;

    @Override
    public ItemDataType getType(){
        return ItemDataType.INSTANCE;
    }

    @Override
    public ResourceLocation getRendererId(){
        return Inline.id( "item");
    }

    public ItemStack getStack(){
        return stack;
    }

    public ItemInlineData(ItemStack stack){
        this.stack = stack;
    }

    // gives a character that's styled to appear as the item, with the same hover event
    public static Component make(ItemStack stack){
        HoverEvent hover = new HoverEvent(HoverEvent.Action.SHOW_ITEM, new ItemStackInfo(stack));
        Style style = ((InlineStyle)Style.EMPTY.withHoverEvent(hover)).withInlineData(new ItemInlineData(stack));
        return Component.literal("#").setStyle(style);
    }

    public static class ItemDataType implements InlineDataType<ItemInlineData> {
        public static ItemDataType INSTANCE = new ItemDataType();

        @Override
        public ResourceLocation getId(){
            return Inline.id( "item");
        }

        @Override
        public Codec<ItemInlineData> getCodec(){
            return ItemStack.CODEC.xmap(
                ItemInlineData::new,
                ItemInlineData::getStack
            );
        }
    }
}
