package com.samsthenerd.inline.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.samsthenerd.inline.utils.Spritelike.SpritelikeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.render.*;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

import java.util.HashMap;
import java.util.Map;

public class SpritelikeRenderers {
    private static final Map<SpritelikeType, SpritelikeRenderer> RENDERER_MAP = new HashMap<>();

    private static final SpritelikeRenderer DEFAULT_RENDERER = new SpritelikeRenderer();

    public static void registerRenderer(SpritelikeType type, SpritelikeRenderer renderer){
        RENDERER_MAP.put(type, renderer);
    }

    public static SpritelikeRenderer getRenderer(SpritelikeType type){
        if(RENDERER_MAP.containsKey(type)){
            return RENDERER_MAP.get(type);
        }
        return DEFAULT_RENDERER;
    }

    public static SpritelikeRenderer getRenderer(Spritelike sprite){
        return getRenderer(sprite.getType());
    }

    public static class SpritelikeRenderer{
        public void drawSpriteWithLight(Spritelike sprite, GuiGraphics ctx, float x, float y, float z, float width, float height, int light, int argb) {
            ResourceLocation texture = sprite.getTextureId();
            if(texture == null) return;
            RenderSystem.setShaderTexture(0, texture);
            RenderSystem.setShader(GameRenderer::getRendertypeEntityTranslucentShader);
            Matrix4f matrix4f = ctx.pose().last().pose();
            RenderType renderLayer = RenderType.entityTranslucent(texture);
            VertexConsumer vc = ctx.bufferSource().getBuffer(renderLayer);
            SpriteUVRegion uvs = sprite.getUVs();
            vc.addVertex(matrix4f, x, y, z)
                .setColor(argb)
                .setUv((float)uvs.minU(), (float)uvs.minV())
                .setOverlay(OverlayTexture.NO_OVERLAY)
                .setLight(light)
                .setNormal(ctx.pose().last(), 0, 0, 1f)
                ;
            vc.addVertex(matrix4f, x, y+height, z)
                .setColor(argb)
                .setUv((float)uvs.minU(), (float)uvs.maxV())
                .setOverlay(OverlayTexture.NO_OVERLAY)
                .setLight(light)
                .setNormal(ctx.pose().last(), 0, 0, 1f)
                ;
            vc.addVertex(matrix4f, x+width, y+height, z)
                .setColor(argb)
                .setUv((float)uvs.maxU(), (float)uvs.maxV())
                .setOverlay(OverlayTexture.NO_OVERLAY)
                .setLight(light)
                .setNormal(ctx.pose().last(), 0, 0, 1f)
                ;
            vc.addVertex(matrix4f, x+width, y, z)
                .setColor(argb)
                .setUv((float)uvs.maxU(), (float)uvs.minV())
                .setOverlay(OverlayTexture.NO_OVERLAY)
                .setLight(light)
                .setNormal(ctx.pose().last(), 0, 0, 1f)
                ;

            ctx.bufferSource().endBatch(renderLayer);
        }
        
        public void drawSprite(Spritelike sprite, GuiGraphics ctx, float x, float y, float z, float width, float height){
            ResourceLocation texture = sprite.getTextureId();
            if(texture == null) return;
            RenderSystem.setShaderTexture(0, texture);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            Matrix4f matrix4f = ctx.pose().last().pose();
            SpriteUVRegion uvs = sprite.getUVs();
            BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferBuilder.addVertex(matrix4f, x, y, z)
                .setUv((float) uvs.minU(), (float) uvs.minV());
            bufferBuilder.addVertex(matrix4f, x, y+height, z)
                .setUv((float) uvs.minU(), (float) uvs.maxV());
            bufferBuilder.addVertex(matrix4f, x+width, y+height, z)
                .setUv((float) uvs.maxU(), (float) uvs.maxV());
            bufferBuilder.addVertex(matrix4f, x+width, y, z)
                .setUv((float) uvs.maxU(), (float) uvs.minV());

            BufferUploader.drawWithShader(bufferBuilder.buildOrThrow());
        }
    }
}
