/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.mixin.core;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.impl.InlineStyle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Style.class})
public class MixinInlineStyle
implements InlineStyle {
    @Unique
    private final Map<InlineStyle.ISComponent<?>, Object> components = new HashMap();

    @Unique
    private Style getCopy() {
        return InlineStyle.makeCopy((Style)this);
    }

    @Override
    public Style withInlineData(InlineData data) {
        return this.getCopy().setComponent(InlineStyle.INLINE_DATA_COMP, (Object)data);
    }

    @Override
    public <C> C getComponent(InlineStyle.ISComponent<C> component) {
        return (C)this.components.getOrDefault(component, component.defaultValue());
    }

    @Override
    public Map<InlineStyle.ISComponent<?>, Object> getComponentMap() {
        return Map.copyOf(this.components);
    }

    @Override
    public Set<InlineStyle.ISComponent<?>> getComponents() {
        return new HashSet(this.components.keySet());
    }

    @Override
    public <C> Style withComponent(InlineStyle.ISComponent<C> component, @Nullable C value) {
        return this.getCopy().setComponent(component, value);
    }

    @Override
    public <C> Style setComponent(InlineStyle.ISComponent<C> component, @Nullable C value) {
        if (value == null) {
            this.components.remove(component);
        } else {
            this.components.put(component, value);
        }
        return (Style)this;
    }

    @ModifyReturnValue(method={"applyTo(Lnet/minecraft/network/chat/Style;)Lnet/minecraft/network/chat/Style;"}, at={@At(value="RETURN")})
    private Style InlineStyWithParent(Style original, Style parent) {
        Style maybeNewStyle = InlineStyle.makeCopy(original);
        this.keepData(maybeNewStyle);
        for (InlineStyle.ISComponent comp : parent.getComponents()) {
            if (!maybeNewStyle.getComponents().contains(comp)) {
                maybeNewStyle.setComponent(comp, parent.getComponent(comp));
                continue;
            }
            maybeNewStyle.setComponent(comp, comp.merger().apply(this.getComponent(comp), parent.getComponent(comp)));
        }
        return maybeNewStyle;
    }

    @ModifyReturnValue(method={"equals(Ljava/lang/Object;)Z"}, at={@At(value="RETURN")})
    private boolean InlineStyEquals(boolean original, Object obj) {
        if (original && this != obj && obj instanceof InlineStyle) {
            InlineStyle style = (InlineStyle)obj;
            Set allComps = Stream.concat(this.components.keySet().stream(), style.getComponents().stream()).collect(Collectors.toSet());
            for (InlineStyle.ISComponent comp : allComps) {
                if (Objects.equals(this.getComponent(comp), style.getComponent(comp))) continue;
                return false;
            }
        }
        return original;
    }

    @ModifyReturnValue(method={"getFont()Lnet/minecraft/resources/ResourceLocation;"}, at={@At(value="RETURN")})
    private ResourceLocation overrideFont(ResourceLocation original) {
        if (this.getInlineData() != null) {
            return Inline.id("dummy_font");
        }
        return original;
    }

    @Unique
    private Style keepData(Style newStyle) {
        for (InlineStyle.ISComponent<?> comp : this.components.keySet()) {
            newStyle.setComponent(comp, this.getComponent(comp));
        }
        return newStyle;
    }

    @ModifyReturnValue(method={"withColor(Lnet/minecraft/network/chat/TextColor;)Lnet/minecraft/network/chat/Style;"}, at={@At(value="RETURN")})
    private Style fixWithColor(Style newStyle, TextColor color) {
        return this.keepData(newStyle);
    }

    @ModifyReturnValue(method={"withBold(Ljava/lang/Boolean;)Lnet/minecraft/network/chat/Style;"}, at={@At(value="RETURN")})
    private Style fixWithBold(Style newStyle, Boolean boldBool) {
        return this.keepData(newStyle);
    }

    @ModifyReturnValue(method={"withItalic(Ljava/lang/Boolean;)Lnet/minecraft/network/chat/Style;"}, at={@At(value="RETURN")})
    private Style fixWithItalic(Style newStyle, Boolean boldBool) {
        return this.keepData(newStyle);
    }

    @ModifyReturnValue(method={"withUnderlined(Ljava/lang/Boolean;)Lnet/minecraft/network/chat/Style;"}, at={@At(value="RETURN")})
    private Style fixWithUnderline(Style newStyle, Boolean boldBool) {
        return this.keepData(newStyle);
    }

    @ModifyReturnValue(method={"withStrikethrough(Ljava/lang/Boolean;)Lnet/minecraft/network/chat/Style;"}, at={@At(value="RETURN")})
    private Style fixWithStrikethrough(Style newStyle, Boolean boldBool) {
        return this.keepData(newStyle);
    }

    @ModifyReturnValue(method={"withObfuscated(Ljava/lang/Boolean;)Lnet/minecraft/network/chat/Style;"}, at={@At(value="RETURN")})
    private Style fixWithObfuscated(Style newStyle, Boolean boldBool) {
        return this.keepData(newStyle);
    }

    @ModifyReturnValue(method={"withClickEvent(Lnet/minecraft/network/chat/ClickEvent;)Lnet/minecraft/network/chat/Style;"}, at={@At(value="RETURN")})
    private Style fixWithClickEvent(Style newStyle, ClickEvent clickEvent) {
        return this.keepData(newStyle);
    }

    @ModifyReturnValue(method={"withHoverEvent(Lnet/minecraft/network/chat/HoverEvent;)Lnet/minecraft/network/chat/Style;"}, at={@At(value="RETURN")})
    private Style fixWithHoverEvent(Style newStyle, HoverEvent hoverEvent) {
        return this.keepData(newStyle);
    }

    @ModifyReturnValue(method={"withInsertion(Ljava/lang/String;)Lnet/minecraft/network/chat/Style;"}, at={@At(value="RETURN")})
    private Style fixWithInsertion(Style newStyle, String insertionString) {
        return this.keepData(newStyle);
    }

    @ModifyReturnValue(method={"withFont(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/network/chat/Style;"}, at={@At(value="RETURN")})
    private Style fixWithFont(Style newStyle, ResourceLocation fontID) {
        return this.keepData(newStyle);
    }

    @ModifyReturnValue(method={"applyFormat(Lnet/minecraft/ChatFormatting;)Lnet/minecraft/network/chat/Style;"}, at={@At(value="RETURN")})
    private Style fixWithFormatting(Style newStyle, ChatFormatting formatting) {
        return this.keepData(newStyle);
    }

    @ModifyReturnValue(method={"applyLegacyFormat(Lnet/minecraft/ChatFormatting;)Lnet/minecraft/network/chat/Style;"}, at={@At(value="RETURN")})
    private Style fixWithExclusiveFormatting(Style newStyle, ChatFormatting formatting) {
        return this.keepData(newStyle);
    }
}

