package com.samsthenerd.inline.utils;

import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.objects.Object2ObjectSortedMaps;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;

/**
 * This is a stupid stupid stupid thing to let our DrawContext have an immediate even if the actual vc provider is
 * not an immediate. It exists to support compat with mods that render text to non-standard vertex consumers (like
 * glowcase for example).
 */
public class VCPImmediateButImLyingAboutIt extends MultiBufferSource.BufferSource {
    private MultiBufferSource provider;

    /**
     * Make sure that we're not making a fake immediate when we have a real immediate we could be using.
     */
    public static BufferSource of(MultiBufferSource provider){
        if(provider instanceof BufferSource imm){
            return imm;
        }
        return new VCPImmediateButImLyingAboutIt(provider);
    }

    private VCPImmediateButImLyingAboutIt(MultiBufferSource provider){
//        super(Tessellator.getInstance().getBuffer(), Map.of());
        super(null, Object2ObjectSortedMaps.emptyMap()); // TODO: write an accessor for the buffer allocator?
        this.provider = provider;
    }

    @Override
    public VertexConsumer getBuffer(RenderType renderLayer) {
        return provider.getBuffer(renderLayer);
    }

    @Override
    public void endLastBatch() {
        // nop
    }

    @Override
    public void endBatch() {
        // nop
    }

    @Override
    public void endBatch(RenderType layer) {
        // nop
    }
}
