package com.samsthenerd.inline.tooltips.components;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.samsthenerd.inline.tooltips.data.EntityDisplayTTData;
import com.samsthenerd.inline.utils.EntityCradle;
import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;

public class EntityDisplayTTComp implements ClientTooltipComponent {
    public static final float DEFAULT_RENDER_SIZE = 96f;

    private EntityCradle cradle;
    private BiFunction<Integer, Integer, Integer> widthProvider;

    public EntityDisplayTTComp(EntityDisplayTTData tt) {
        this.cradle = tt.cradle;
        this.widthProvider = tt.widthProvider;
    }

    @Override
    public void renderImage(Font font, int mouseX, int mouseY, GuiGraphics context) {
        // reload it just incase it failed the first time or whatever ?
        Entity ent = cradle.getEntity(Minecraft.getInstance().level);
        if(ent == null) return;

        AABB bounds = ent.getBoundingBox().inflate(0, 0.05, 0);

        double height = bounds.getYsize();

        float rot = 15f;

        EntityRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(ent);
        PoseStack matrices = context.pose();
        matrices.pushPose();
        int rHeight = getRenderHeight();
        int ttWidth = getWidth(font);
        matrices.translate(mouseX + ttWidth/2.0, mouseY, 500);
        float scaleFactor = (float)(rHeight/height);
        matrices.scale(scaleFactor, -scaleFactor, scaleFactor);
        matrices.translate(0, -height, 0);
        Minecraft client = Minecraft.getInstance();
        // float rotation = 90f * (Util.getMeasuringTimeMs() / 1000f + data.getUniqueOffset());
        matrices.mulPose(Axis.YP.rotationDegrees(rot));
        renderer.render(ent, 0, 0, matrices, context.bufferSource(), LightTexture.FULL_BRIGHT);
        matrices.popPose();
    }

    @Override
    public int getWidth(Font pFont) {
        Entity ent = cradle.getEntity(Minecraft.getInstance().level);
        if(ent == null) return 0;

        // Box bounds = ent.getBoundingBox().expand(0.15, 0.1, 0.15);
        AABB bounds = ent.getBoundingBox().inflate(0, 0.05, 0);

        double width = bounds.getXsize();
        double depth = bounds.getZsize();
        double height = bounds.getYsize();

        float rot = 15f;
        double radRot = Math.toRadians(rot % 90);
        double pWidth = (width * Math.cos(radRot)) + (depth * Math.sin(radRot));

        return (int) (widthProvider.apply(
            (int) (pWidth*100),
            (int) (height*100)
        )) + 16;
    }

    private int getRenderHeight(){
        Entity ent = cradle.getEntity(Minecraft.getInstance().level);
        if(ent == null) return 0;

        AABB bounds = ent.getBoundingBox().inflate(0, 0.05, 0);

        double width = bounds.getXsize();
        double depth = bounds.getZsize();
        double height = bounds.getYsize();

        float rot = 15f;
        double radRot = Math.toRadians(rot % 90);
        double pWidth = (width * Math.cos(radRot)) + (depth * Math.sin(radRot));

        int realWidth = widthProvider.apply(
            (int) (pWidth*100),
            (int) (height*100)
        );
        if(pWidth == 0){
            return 0;
        }
        return (int)(realWidth * (height / pWidth));
    }

    @Override
    public int getHeight() {
        return getRenderHeight() + 4; 
    }
}
