package com.samsthenerd.inline.api.data;


import com.mojang.serialization.Codec;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.tooltips.CustomTooltipManager;
import com.samsthenerd.inline.tooltips.providers.EntityTTProvider;
import com.samsthenerd.inline.utils.cradles.PlayerCradle;
import java.util.Objects;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.component.ResolvableProfile;

public class PlayerHeadData implements InlineData<PlayerHeadData> {
    private ResolvableProfile profile;

    public PlayerHeadData(ResolvableProfile profile) {
        this.profile = profile;
    }

    @Override
    public PlayerHeadDataType getType() {
        return PlayerHeadDataType.INSTANCE;
    }

    @Override
    public ResourceLocation getRendererId() {
        return Inline.id("playerhead");
    }

    public HoverEvent getEntityDisplayHoverEvent() {
        return new HoverEvent(
          HoverEvent.Action.SHOW_ITEM,
          new HoverEvent.ItemStackInfo(CustomTooltipManager.getForTooltip(EntityTTProvider.INSTANCE, new PlayerCradle(profile())))
        );
    }

    public Style getDataStyle(boolean withAdditional) {
        Style superStyle = InlineData.super.asStyle(withAdditional);
        if (!withAdditional) return superStyle;
        return superStyle.applyTo(Style.EMPTY.withHoverEvent(getEntityDisplayHoverEvent()));
    }

    public ResolvableProfile profile() {
        if (!profile.isResolved()) {
            profile.resolve().thenAcceptAsync(profileComponent -> {
                profile = profileComponent;
            });
        }
        return profile;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (obj == null || obj.getClass() != this.getClass()) return false;
        var that = (PlayerHeadData) obj;
        return Objects.equals(this.profile, that.profile);
    }

    @Override
    public int hashCode() {
        return Objects.hash(profile);
    }

    @Override
    public String toString() {
        return "PlayerHeadData[" +
               "profile=" + profile + ']';
    }


    public static class PlayerHeadDataType implements InlineDataType<PlayerHeadData> {
        public static PlayerHeadDataType INSTANCE = new PlayerHeadDataType();

        @Override
        public ResourceLocation getId() {
            return Inline.id("playerhead");
        }

        @Override
        public Codec<PlayerHeadData> getCodec() {
            return ResolvableProfile.CODEC.xmap(PlayerHeadData::new, data -> data.profile);
        }
    }
}
