package com.samsthenerd.inline.utils.cradles;

import com.mojang.serialization.Codec;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.utils.EntityCradle;
import com.samsthenerd.inline.utils.FakeClientPlayerMaker;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.level.Level;

/**
 * An entity cradle backed by a player GameProfile
 */
public class PlayerCradle extends EntityCradle {

    private final ResolvableProfile profile;

    public PlayerCradle(ResolvableProfile profile){
        this.profile = profile;
    }

    public ResolvableProfile getProfile(){
        return profile;
    }

    public CradleType<?> getType(){
        return PlayerCradleType.INSTANCE;
    }

    @Override
    public String getId(){
        return profile.id().map(Object::toString).orElseGet(() -> profile.name().get());
    }

    public Entity getEntity(Level world){
        return FakeClientPlayerMaker.getPlayerEntity(profile);
    }

    private static class PlayerCradleType implements CradleType<PlayerCradle>{

        public static PlayerCradleType INSTANCE = EntityCradle.addCradleType(new PlayerCradleType());

        public ResourceLocation getId(){
            return Inline.id( "nbt");
        }

        public Codec<PlayerCradle> getCodec(){
            return ResolvableProfile.CODEC.xmap(
                PlayerCradle::new,
                PlayerCradle::getProfile
            );
        }
    }
}
