package com.samsthenerd.inline.tooltips.providers;

import com.mojang.serialization.Codec;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.data.ModIconData;
import com.samsthenerd.inline.tooltips.CustomTooltipManager.CustomTooltipProvider;
import com.samsthenerd.inline.tooltips.data.SpriteTooltipData;
import com.samsthenerd.inline.utils.Spritelike;
import com.samsthenerd.inline.xplat.IModMeta;
import org.jetbrains.annotations.NotNull;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.tooltip.TooltipComponent;

public class ModDataTTProvider implements CustomTooltipProvider<IModMeta>{

    public static final ModDataTTProvider INSTANCE = new ModDataTTProvider();

    @Override
    public ResourceLocation getId(){
        return Inline.id("moddata");
    }

    @Override
    @NotNull
    public List<Component> getTooltipText(IModMeta mod){
        List<Component> modInfo = new ArrayList<>();
        if(mod == null) return modInfo;
        MutableComponent title = Component.literal(mod.getName()).setStyle(Style.EMPTY.withBold(true));
        MutableComponent description = Component.literal(mod.getDescription().replace("\n", "")).setStyle(Style.EMPTY.withColor(ChatFormatting.GRAY));
        modInfo.add(title);
        modInfo.add(description);
        return modInfo;
    }

    @Override
    @NotNull
    public Optional<TooltipComponent> getTooltipData(IModMeta mod){
        if(mod == null) return Optional.empty();

        Spritelike iconSprite = ModIconData.spriteFromModid(mod.getModId(), false);
        if(iconSprite == null) return Optional.empty();
        return Optional.of(new SpriteTooltipData(iconSprite, (w, h) -> 32));
    }

    @Override
    @NotNull
    public Codec<IModMeta> getCodec(){
        return Codec.STRING.xmap(
            modid -> IModMeta.getMod(modid).orElse(null),
            IModMeta::getModId
        );
    }
}
