package com.samsthenerd.inline.utils;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.systems.RenderSystem;
import com.samsthenerd.inline.Inline;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

public class URLTextureUtils {

    private static final Map<ResourceLocation, ResourceLocation> LOADED_TEXTURES = Collections.synchronizedMap(new HashMap<>());
    // same key as the loaded textures
    private static final Map<ResourceLocation, Tuple<Integer, Integer>> TEXTURE_DIMENSIONS = Collections.synchronizedMap(new HashMap<>());

    // informed by hellozyemlya on discord
    public static ResourceLocation loadTextureFromURL(String url, ResourceLocation textureId){
        ResourceLocation maybeTexture = LOADED_TEXTURES.get(textureId);
        if(maybeTexture != null){
            return maybeTexture;
        }
        // Inline.logPrint("Loading texture from URL: " + url);
        CompletableFuture.runAsync(() -> {
            try{
                URL textureUrl = new URL(url);
                InputStream stream = textureUrl.openStream();
                // Inline.logPrint("in thread maybe ?"); 
                try{
                    NativeImage baseImage = NativeImage.read(stream);
                    if(baseImage == null){
                        // Inline.logPrint("null baseImage: " + url.toString());
                        return;
                    }
                    DynamicTexture texture = new DynamicTexture(baseImage);
                    // NativeImage baseImage = texture.getImage();
                    Runnable registerTextureRunnable = () -> {
                        ResourceLocation actualTextureId = Minecraft.getInstance().getTextureManager().register(textureId.toLanguageKey(), texture);
                        LOADED_TEXTURES.put(textureId, actualTextureId);
                        TEXTURE_DIMENSIONS.put(textureId, new Tuple<>(baseImage.getWidth(), baseImage.getHeight()));
                    };
                    Minecraft.getInstance().execute(() -> {
                        Objects.requireNonNull(registerTextureRunnable);
                        RenderSystem.recordRenderCall(registerTextureRunnable::run);
                    });
                    
                } catch (Exception e){
                    Inline.LOGGER.error("Failed to load texture from URL: " + url + "\n:" + e);
                }
            } catch (Exception e){
                Inline.LOGGER.error("Failed to load texture from URL: " + url + "\n:" + e);
            }
            });
        return ResourceLocation.parse("");
    }

    @Nullable
    public static Tuple<Integer, Integer> getTextureDimensions(ResourceLocation textureId){
        return TEXTURE_DIMENSIONS.get(textureId);
    }
}
