package com.samsthenerd.inline.utils;


import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;

public class URLSprite extends Spritelike{
    
    private String url;
    private ResourceLocation id;
    private ResourceLocation textureID;
    private float minU;
    private float minV;
    private float maxU;
    private float maxV;

    public URLSprite(String url, ResourceLocation id, float minU, float minV, float maxU, float maxV){
        this.url = url;
        this.id = id;
        this.minU = minU;
        this.minV = minV;
        this.maxU = maxU;
        this.maxV = maxV;
    }

    public URLSprite(String url, ResourceLocation id){
        this(url, id, 0, 0, 1, 1);
    }

    public SpritelikeType getType(){
        return UrlSpriteType.INSTANCE;
    }

    public ResourceLocation getTextureId(){
        return URLTextureUtils.loadTextureFromURL(url, id);
    }

    public ResourceLocation getId(){
        return id;
    }

    public String getUrl(){
        return url;
    }

    // should these take some timing input to allow for animated sprites ?
    public float getMinU(){
        return this.minU;
    }
    public float getMinV(){
        return this.minV;
    }
    public float getMaxU(){
        return this.maxU;
    }
    public float getMaxV(){
        return this.maxV;
    }

    public int getTextureWidth(){
        getTextureId(); // force it to load real quick
        Tuple<Integer, Integer> dims = URLTextureUtils.getTextureDimensions(id);
        if(dims == null){
            return 0;
        }
        return dims.getA();
    }

    public int getTextureHeight(){
        getTextureId(); // force it to load real quick
        Tuple<Integer, Integer> dims = URLTextureUtils.getTextureDimensions(id);
        if(dims == null){
            return 0;
        }
        return dims.getB();
    }

    public static class UrlSpriteType implements SpritelikeType{
        public static final UrlSpriteType INSTANCE = new UrlSpriteType();
        private static final MapCodec<URLSprite> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group(
            Codec.STRING.fieldOf("url").forGetter(URLSprite::getUrl),
            ResourceLocation.CODEC.fieldOf("id").forGetter(URLSprite::getId),
            Codec.FLOAT.optionalFieldOf("minU", 0f).forGetter(URLSprite::getMinU),
            Codec.FLOAT.optionalFieldOf("minV", 0f).forGetter(URLSprite::getMinV),
            Codec.FLOAT.optionalFieldOf("maxU", 1f).forGetter(URLSprite::getMaxU),
            Codec.FLOAT.optionalFieldOf("maxV", 1f).forGetter(URLSprite::getMaxV)
        ).apply(instance, URLSprite::new));

        public MapCodec<URLSprite> getCodec(){
            return CODEC;
        }

        public String getId(){
            return "url";
        }
    }
}
