package com.samsthenerd.inline.utils;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.samsthenerd.inline.utils.Spritelike.SpritelikeType;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.render.*;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

import java.util.HashMap;
import java.util.Map;

public class SpritelikeRenderers {
    private static final Map<SpritelikeType, SpritelikeRenderer> RENDERER_MAP = new HashMap<>();

    private static final SpritelikeRenderer DEFAULT_RENDERER = new SpritelikeRenderer();

    public static void registerRenderer(SpritelikeType type, SpritelikeRenderer renderer){
        RENDERER_MAP.put(type, renderer);
    }

    public static SpritelikeRenderer getRenderer(SpritelikeType type){
        if(RENDERER_MAP.containsKey(type)){
            return RENDERER_MAP.get(type);
        }
        return DEFAULT_RENDERER;
    }

    public static SpritelikeRenderer getRenderer(Spritelike sprite){
        return getRenderer(sprite.getType());
    }

    public static class SpritelikeRenderer{
        public void drawSpriteWithLight(Spritelike sprite, GuiGraphics ctx, float x, float y, float z, float width, float height, int light, int argb) {
            ResourceLocation texture = sprite.getTextureId();
            RenderSystem.setShaderTexture(0, texture);
            RenderSystem.setShader(GameRenderer::getRendertypeEntityTranslucentShader);
            Matrix4f matrix4f = ctx.pose().last().pose();
            // BufferBuilder bufferBuilder = Tessellator.getInstance().getBuffer();
            RenderType renderLayer = RenderType.entityTranslucent(texture);
            VertexConsumer vc = ctx.bufferSource().getBuffer(renderLayer);
            vc.addVertex(matrix4f, x, y, z).setColor(argb).setUv(sprite.getMinU(), sprite.getMinV()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(ctx.pose().last(), 0, 0, 1f);
            vc.addVertex(matrix4f, x, y+height, z).setColor(argb).setUv(sprite.getMinU(), sprite.getMaxV()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(ctx.pose().last(), 0, 0, 1f);
            vc.addVertex(matrix4f, x+width, y+height, z).setColor(argb).setUv(sprite.getMaxU(), sprite.getMaxV()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(ctx.pose().last(), 0, 0, 1f);
            vc.addVertex(matrix4f, x+width, y, z).setColor(argb).setUv(sprite.getMaxU(), sprite.getMinV()).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(ctx.pose().last(), 0, 0, 1f);

            ctx.bufferSource().endBatch(renderLayer);
        }

//        public void drawSpriteWithLightNoNormals(Spritelike sprite, DrawContext ctx, float x, float y, float z, float width, float height, int light, int argb){
//            Identifier texture = sprite.getTextureId();
//            RenderSystem.setShaderTexture(0, texture);
//            RenderSystem.setShader(GameRenderer::getRenderTypeTextIntensityProgram);
//            Matrix4f matrix4f = ctx.getMatrices().peek().getPositionMatrix();
//            // BufferBuilder bufferBuilder = Tessellator.getInstance().getBuffer();
//            RenderLayer renderLayer = RenderLayer.getTextIntensity(texture);
//            VertexConsumer vc = ctx.getVertexConsumers().getBuffer(renderLayer);
//            vc.vertex(matrix4f, x, y, z).color(argb).texture(sprite.getMinU(), sprite.getMinV()).light(light).next();
//            vc.vertex(matrix4f, x, y+height, z).color(argb).texture(sprite.getMinU(), sprite.getMaxV()).light(light).next();
//            vc.vertex(matrix4f, x+width, y+height, z).color(argb).texture(sprite.getMaxU(), sprite.getMaxV()).light(light).next();
//            vc.vertex(matrix4f, x+width, y, z).color(argb).texture(sprite.getMaxU(), sprite.getMinV()).light(light).next();
//
//            ctx.getVertexConsumers().draw(renderLayer);
//        }
        
        public void drawSprite(Spritelike sprite, GuiGraphics ctx, float x, float y, float z, float width, float height){
            ResourceLocation texture = sprite.getTextureId();
            RenderSystem.setShaderTexture(0, texture);
            RenderSystem.setShader(GameRenderer::getPositionTexShader);
            Matrix4f matrix4f = ctx.pose().last().pose();
            BufferBuilder bufferBuilder = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            bufferBuilder.addVertex(matrix4f, x, y, z).setUv(sprite.getMinU(), sprite.getMinV());
            bufferBuilder.addVertex(matrix4f, x, y+height, z).setUv(sprite.getMinU(), sprite.getMaxV());
            bufferBuilder.addVertex(matrix4f, x+width, y+height, z).setUv(sprite.getMaxU(), sprite.getMaxV());
            bufferBuilder.addVertex(matrix4f, x+width, y, z).setUv(sprite.getMaxU(), sprite.getMinV());
            BufferUploader.drawWithShader(bufferBuilder.buildOrThrow());
        }
    }
}
