package com.samsthenerd.inline.utils;

import com.samsthenerd.inline.mixin.feature.playerskins.MixinAccessPlayerModelParts;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.RemotePlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.component.ResolvableProfile;

public class FakeClientPlayerMaker {
    public static Entity getPlayerEntity(ResolvableProfile profile) {
        Player player = new RemotePlayer(Minecraft.getInstance().level, profile.gameProfile()) {
            @Override
            public boolean shouldShowName() {
                return false;
            }
        };
        player.yCloakO = player.yCloak = (player.getY() - 0.5);
        player.xCloakO = player.xCloak = player.getX();
        player.zCloakO = player.zCloak = player.getZ();
        player.getEntityData().set(MixinAccessPlayerModelParts.getPlayerModelParts(), (byte) 0b11111111);
        return player;
    }
}
