package com.samsthenerd.inline.tooltips.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.samsthenerd.inline.tooltips.data.SpriteTooltipData;
import com.samsthenerd.inline.utils.Spritelike;
import com.samsthenerd.inline.utils.SpritelikeRenderers;
import java.util.function.BiFunction;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;

public class SpriteTooltipComponent implements ClientTooltipComponent {
    public static final float DEFAULT_RENDER_SIZE = 96f;

    private Spritelike sprite;
    private BiFunction<Integer, Integer, Integer> widthProvider;

    public SpriteTooltipComponent(SpriteTooltipData tt) {
        this.sprite = tt.sprite;
        this.widthProvider = tt.widthProvider;
    }

    @Override
    public void renderImage(Font font, int mouseX, int mouseY, GuiGraphics context) {
        // reload it just incase it failed the first time or whatever ?
        ResourceLocation textureId = sprite.getTextureId();
        if(textureId == null || textureId.equals(ResourceLocation.parse(""))){
            return;
        }
        PoseStack ps = context.pose();
        ps.pushPose();
        ps.translate(mouseX, mouseY, 500);
        RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
        
        SpritelikeRenderers.getRenderer(sprite).drawSprite(sprite, context, 0, 0, 0, getWidth(font), getRenderHeight());


        // float scale = ((float)getWidth(font)) / sprite.getSpriteWidth();
        // ps.scale(scale, scale, 1f);
        // context.drawTexture(textureId, 0, 0, 0, 0, 0, texture.getWidth(), texture.getHeight(), texture.getWidth(), texture.getHeight());

        ps.popPose();
    }

    @Override
    public int getWidth(Font pFont) {
        return widthProvider.apply(
            (int) ((sprite.getMaxU()-sprite.getMinU()) * sprite.getTextureWidth()),
            (int) ((sprite.getMaxV()-sprite.getMinV()) * sprite.getTextureHeight())
        );
    }

    private int getRenderHeight(){
        int realWidth = widthProvider.apply(
            (int) ((sprite.getMaxU()-sprite.getMinU()) * sprite.getTextureWidth()),
            (int) ((sprite.getMaxV()-sprite.getMinV()) * sprite.getTextureHeight())
        );
        if(realWidth == 0 || sprite.getTextureWidth() == 0){
            return 0;
        }
        return (int)(realWidth * ((double)sprite.getTextureHeight())/sprite.getTextureWidth());
    }

    @Override
    public int getHeight() {
        return getRenderHeight() + 4;
    }
}
