package com.samsthenerd.inline.mixin.prompts;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.CommandSuggestions;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.ChatScreen;

@Mixin(ChatScreen.class)
public class MixinSuggestInChat {

    @Shadow
    protected EditBox chatField;


    @WrapOperation(
        method="render(Lnet/minecraft/client/gui/DrawContext;IIF)V",
        at=@At(
            value="INVOKE",
            target="net/minecraft/client/gui/screen/ChatInputSuggestor.render (Lnet/minecraft/client/gui/DrawContext;II)V"
        )
    )
    public void renderInlineSuggestions(CommandSuggestions chatSuggestor, GuiGraphics context, int mouseX, int mouseY, Operation<Void> original){
        Font textRenderer = Minecraft.getInstance().font;
        int textWidth = textRenderer.width(chatField.getValue());
        // context.drawText(textRenderer, chatField.getText(), textWidth+chatField.getX(), chatField.getY()-12, 0xFFFFFF, true);
        original.call(chatSuggestor, context, mouseX, mouseY);
    }
}
