package com.samsthenerd.inline.api.matching;

import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

/**
 * User-facing information about a matcher. For most cases you can just use
 * {@link MatcherInfo#fromId(id)} and add the translations in your lang files.
 */
public class MatcherInfo {
    private final Component rawTitle;
    private final Component styledTitle;
    private final Component example;
    private final Component description;

    public MatcherInfo(Component rawTitle, Component styledTitle, Component example, Component description){
        this.rawTitle = rawTitle;
        this.styledTitle = styledTitle;
        this.example = example;
        this.description = description;
    }

    public static MatcherInfo fromId(ResourceLocation id){
        return new MatcherInfo(
            Component.translatable("matcher." + id.getNamespace() + "." + id.getPath() + ".title"),
            Component.translatable("matcher." + id.getNamespace() + "." + id.getPath() + ".title.styled"),
            Component.translatable("matcher." + id.getNamespace() + "." + id.getPath() + ".example"),
            Component.translatable("matcher." + id.getNamespace() + "." + id.getPath() + ".description")
        );
    }

    public Component getTitle(boolean styled){
        if(styled){
            return styledTitle;
        }
        return rawTitle;
    }

    public Component getExample(){
        return example;
    }

    public Component getDescription(){
        return description;
    }
}
