package com.samsthenerd.inline.api.data;

import com.mojang.serialization.Codec;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.utils.Spritelike;
import net.minecraft.resources.ResourceLocation;

public class SpriteInlineData implements InlineData<SpriteInlineData>{
    public SpriteDataType getType(){
        return SpriteDataType.INSTANCE;
    }

    @Override
    public ResourceLocation getRendererId(){
        return Inline.id( "spritelike");
    }

    public final Spritelike sprite;

    public SpriteInlineData(Spritelike sprite){
        this.sprite = sprite;
    }

    public static class SpriteDataType implements InlineDataType<SpriteInlineData> {
        public static SpriteDataType INSTANCE = new SpriteDataType();

        @Override
        public ResourceLocation getId(){
            return Inline.id( "spritelike");
        }

        @Override
        public Codec<SpriteInlineData> getCodec(){
            return Spritelike.CODEC.xmap(
                SpriteInlineData::new,
                data -> data.sprite
            );
        }
    }
}
