package com.samsthenerd.inline.api.client.renderers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.client.GlowHandling;
import com.samsthenerd.inline.api.client.InlineRenderer;
import com.samsthenerd.inline.api.data.EntityInlineData;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class InlineEntityRenderer implements InlineRenderer<EntityInlineData>{

    public static final InlineEntityRenderer INSTANCE = new InlineEntityRenderer();

    public ResourceLocation getId(){
        return Inline.id( "entity");
    }

    public int render(EntityInlineData data, GuiGraphics context, int index, Style style, int codepoint, TextRenderingContext trContext){
        // only draw it once
        Entity ent = data.getEntity(Minecraft.getInstance().level);
        if(ent == null) return 0;

        float width = ent.getBbWidth();
        float height = ent.getBbHeight();

        float rot = 15f;
        double radRot = Math.toRadians(rot % 90);
        double pWidth = width * (Math.cos(radRot)+Math.sin(radRot));

        int cDist = (int)Math.ceil(pWidth * 8 / height) + 1;
        if(trContext.shadow()){
            return cDist;
        }
        EntityRenderer renderer = Minecraft.getInstance().getEntityRenderDispatcher().getRenderer(ent);
        PoseStack matrices = context.pose();
        matrices.translate(cDist/2.0, 8, 0);
        matrices.scale(8 / height, -8 / height, 8 / height);
        // float rotation = 90f * (Util.getMeasuringTimeMs() / 1000f + data.getUniqueOffset());
        matrices.mulPose(Axis.YP.rotationDegrees(rot));
        renderer.render(ent, 0, 0, matrices, context.bufferSource(), trContext.light());
        return cDist;
    }

    public int charWidth(EntityInlineData data, Style style, int codepoint){
        Entity ent = data.getEntity(Minecraft.getInstance().level);
        if(ent == null) return 0;
        float width = ent.getBbWidth();
        float height = ent.getBbHeight();

        float rot = 15f;
        double radRot = Math.toRadians(rot % 90);
        double pWidth = width * (Math.cos(radRot)+Math.sin(radRot));

        return (int)Math.ceil(pWidth * 8 / height) + 1;
    }

    @Override
    public GlowHandling getGlowPreference(EntityInlineData forData){ return new GlowHandling.Full(forData.cradle.getId()); }
}
