/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.utils.cradles;

import com.mojang.serialization.Codec;
import com.samsthenerd.inline.utils.EntityCradle;
import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class NbtCradle
extends EntityCradle {
    private static final HashMap<CompoundTag, Entity> ENTITY_CACHE = new HashMap();
    private Entity ownCachedEntity;
    private CompoundTag entityTag;

    public NbtCradle(Entity entity) {
        this.entityTag = new CompoundTag();
        entity.m_20223_(this.entityTag);
        this.ownCachedEntity = entity;
        ENTITY_CACHE.put(this.entityTag, entity);
    }

    public NbtCradle(CompoundTag tag) {
        this.entityTag = tag;
    }

    public CompoundTag getTag() {
        return this.entityTag;
    }

    @Override
    public EntityCradle.CradleType<?> getType() {
        return NbtCradleType.INSTANCE;
    }

    @Override
    public Entity getEntity(Level world) {
        if (this.ownCachedEntity != null) {
            return this.ownCachedEntity;
        }
        if (ENTITY_CACHE.containsKey(this.entityTag)) {
            this.ownCachedEntity = ENTITY_CACHE.get(this.entityTag);
            return this.ownCachedEntity;
        }
        this.ownCachedEntity = EntityType.m_20642_((CompoundTag)this.entityTag, (Level)world).orElse(null);
        ENTITY_CACHE.put(this.entityTag, this.ownCachedEntity);
        return this.ownCachedEntity;
    }

    private static class NbtCradleType
    implements EntityCradle.CradleType<NbtCradle> {
        public static NbtCradleType INSTANCE = EntityCradle.addCradleType(new NbtCradleType());

        private NbtCradleType() {
        }

        @Override
        public ResourceLocation getId() {
            return new ResourceLocation("inline", "nbt");
        }

        @Override
        public Codec<NbtCradle> getCodec() {
            return CompoundTag.f_128325_.xmap(NbtCradle::new, NbtCradle::getTag);
        }
    }
}

