package com.samsthenerd.inline.utils.cradles;

import java.util.HashMap;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import com.mojang.serialization.Codec;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.utils.EntityCradle;

/**
 * An entity cradle backed by the entity's full nbt data
 */
public class NbtCradle extends EntityCradle {

    private static final HashMap<CompoundTag, Entity> ENTITY_CACHE = new HashMap<>();

    private Entity ownCachedEntity; // to avoid having to hash the nbt compound every time
    private CompoundTag entityTag;

    public NbtCradle(Entity entity){
        entityTag = new CompoundTag();
        entity.m_20223_(entityTag);
        ownCachedEntity = entity;
        ENTITY_CACHE.put(entityTag, entity);
    }

    public NbtCradle(CompoundTag tag){
        entityTag = tag;
    }

    public CompoundTag getTag(){
        return entityTag;
    }

    public CradleType<?> getType(){
        return NbtCradleType.INSTANCE;
    }

    public Entity getEntity(Level world){
        if(ownCachedEntity != null){
            return ownCachedEntity;
        }
        if(ENTITY_CACHE.containsKey(entityTag)){
            ownCachedEntity = ENTITY_CACHE.get(entityTag);
            return ownCachedEntity;
        }

        ownCachedEntity = EntityType.m_20642_(entityTag, world).orElse(null);
        ENTITY_CACHE.put(entityTag, ownCachedEntity);
        return ownCachedEntity;
    }

    private static class NbtCradleType implements CradleType<NbtCradle>{

        public static NbtCradleType INSTANCE = EntityCradle.addCradleType(new NbtCradleType());

        public ResourceLocation getId(){
            return new ResourceLocation(Inline.MOD_ID, "nbt");
        }

        public Codec<NbtCradle> getCodec(){
            return CompoundTag.f_128325_.xmap(NbtCradle::new, NbtCradle::getTag);
        }
    }
}
