package com.samsthenerd.inline.tooltips.components;

import java.util.function.BiFunction;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.resources.ResourceLocation;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.samsthenerd.inline.tooltips.data.SpriteTooltipData;
import com.samsthenerd.inline.utils.SpriteUVRegion;
import com.samsthenerd.inline.utils.Spritelike;
import com.samsthenerd.inline.utils.SpritelikeRenderers;

public class SpriteTooltipComponent implements ClientTooltipComponent {
    public static final float DEFAULT_RENDER_SIZE = 96f;

    private Spritelike sprite;
    private BiFunction<Integer, Integer, Integer> widthProvider;

    public SpriteTooltipComponent(SpriteTooltipData tt) {
        this.sprite = tt.sprite;
        this.widthProvider = tt.widthProvider;
    }

    @Override
    public void m_183452_(Font font, int mouseX, int mouseY, GuiGraphics context) {
        // reload it just incase it failed the first time or whatever ?
        ResourceLocation textureId = sprite.getTextureId();
        if(textureId == null || textureId.equals(new ResourceLocation(""))){
            return;
        }
        PoseStack ps = context.m_280168_();
        ps.m_85836_();
        ps.m_252880_(mouseX, mouseY, 500);
        RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
        
        SpritelikeRenderers.getRenderer(sprite).drawSprite(sprite, context, 0, 0, 0, m_142069_(font), getRenderHeight());

        ps.m_85849_();
    }

    @Override
    public int m_142069_(Font pFont) {
        SpriteUVRegion uvs = sprite.getUVs();
        return widthProvider.apply(
            (int) (uvs.uWidth() * sprite.getTextureWidth()),
            (int) (uvs.vHeight() * sprite.getTextureHeight())
        );
    }

    private int getRenderHeight(){
        SpriteUVRegion uvs = sprite.getUVs();
        int realWidth = widthProvider.apply(
            (int) (uvs.uWidth() * sprite.getTextureWidth()),
            (int) (uvs.vHeight() * sprite.getTextureHeight())
        );
        if(realWidth == 0 || sprite.getTextureWidth() == 0){
            return 0;
        }
        return (int)(realWidth * ((double)sprite.getTextureHeight())/sprite.getTextureWidth());
    }

    @Override
    public int m_142103_() {
        return getRenderHeight() + 4;
    }
}
