package com.samsthenerd.inline.mixin.core;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.impl.extrahooks.ItemOverlayManager;
import com.samsthenerd.inline.utils.VCPImmediateButImLyingAboutIt;
import net.minecraft.client.render.*;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Matrix3f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(ItemRenderer.class)
public class MixinItemOverlayHook {
    @WrapOperation(
        method="renderItem(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/render/model/json/ModelTransformationMode;ZLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;IILnet/minecraft/client/render/model/BakedModel;)V",
        at=@At(value="INVOKE", target="net/minecraft/client/render/item/ItemRenderer.renderBakedItemModel (Lnet/minecraft/client/render/model/BakedModel;Lnet/minecraft/item/ItemStack;IILnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumer;)V")
    )
    public void renderDetailTextureBakedModel(ItemRenderer renderer, BakedModel model, ItemStack stack, int light, int overlay, PoseStack matrices,
                                              VertexConsumer vertices, Operation<Void> original, ItemStack stackEnclosing, ItemDisplayContext renderMode,
                                              boolean leftHanded, PoseStack matricesEnclosing, MultiBufferSource vcp){
        original.call(renderer, model, stack, light, overlay, matrices, vertices);
        ItemOverlayManager.renderDetailTexture(stack, matrices, renderMode, vcp, light, overlay, leftHanded);
    }

    @WrapOperation(
        method="renderItem(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/render/model/json/ModelTransformationMode;ZLnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;IILnet/minecraft/client/render/model/BakedModel;)V",
        at=@At(value="INVOKE", target="Lnet/minecraft/client/render/item/BuiltinModelItemRenderer;render(Lnet/minecraft/item/ItemStack;Lnet/minecraft/client/render/model/json/ModelTransformationMode;Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/client/render/VertexConsumerProvider;II)V")
    )
    public void renderDetailTextureBuiltInModel(BlockEntityWithoutLevelRenderer renderer, ItemStack stack, ItemDisplayContext renderMode,
                                                PoseStack matrices, MultiBufferSource vcp, int light, int overlay,
                                                Operation<Void> original, ItemStack stackEnclosing, ItemDisplayContext renderModeEncl,
                                                boolean leftHanded, PoseStack matricesEnclosing, MultiBufferSource vcpEncl) {
        original.call(renderer, stack, renderMode, matrices, vcp, light, overlay);
        matricesEnclosing.m_85849_();
        matricesEnclosing.m_85836_();
        matrices.m_252880_(-0.5F, -0.5F, -0.5F);
        ItemOverlayManager.renderDetailTexture(stack, matricesEnclosing, renderMode, vcp, light, overlay, leftHanded);
    }
}