/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.api.client.renderers;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.samsthenerd.inline.api.client.GlowHandling;
import com.samsthenerd.inline.api.client.InlineRenderer;
import com.samsthenerd.inline.api.data.SpriteInlineData;
import com.samsthenerd.inline.utils.SpriteUVRegion;
import com.samsthenerd.inline.utils.SpritelikeRenderers;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class InlineSpriteRenderer
implements InlineRenderer<SpriteInlineData> {
    public static final InlineSpriteRenderer INSTANCE = new InlineSpriteRenderer();

    @Override
    public ResourceLocation getId() {
        return new ResourceLocation("inline", "spritelike");
    }

    @Override
    public int render(SpriteInlineData data, GuiGraphics context, int index, Style style, int codepoint, InlineRenderer.TextRenderingContext trContext) {
        if (data == null || data.sprite == null) {
            return 0;
        }
        SpriteUVRegion uvs = data.sprite.getUVs();
        double height = uvs.vHeight() * (double)data.sprite.getTextureHeight();
        if (height == 0.0) {
            return 0;
        }
        double width = uvs.uWidth() * (double)data.sprite.getTextureWidth();
        float whRatio = (float)(width / height);
        PoseStack matrices = context.m_280168_();
        matrices.m_252880_(0.0f, 0.0f, 1.0f);
        RenderSystem.enableDepthTest();
        SpritelikeRenderers.getRenderer(data.sprite).drawSpriteWithLight(data.sprite, context, 0.0f, 0.0f, 0.0f, 8.0f * whRatio, 8.0f, trContext.light(), data.shouldTint ? trContext.usableColor() : -1);
        return (int)Math.ceil(whRatio * 8.0f);
    }

    @Override
    public int charWidth(SpriteInlineData data, Style style, int codepoint) {
        if (data == null || data.sprite == null) {
            return 0;
        }
        SpriteUVRegion uvs = data.sprite.getUVs();
        double height = uvs.vHeight() * (double)data.sprite.getTextureHeight();
        if (height == 0.0) {
            return 0;
        }
        double width = uvs.uWidth() * (double)data.sprite.getTextureWidth();
        float whRatio = (float)(width / height);
        return (int)Math.ceil(8.0 * (double)whRatio);
    }

    @Override
    public GlowHandling getGlowPreference(SpriteInlineData forData) {
        return new GlowHandling.Full(Objects.requireNonNullElse(forData.sprite.getTextureId(), new ResourceLocation("")).m_214298_() + Integer.toHexString(forData.sprite.hashCode()).toLowerCase());
    }
}

