package com.samsthenerd.inline.mixin.feature.playerskins;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

@Mixin(AbstractClientPlayer.class)
public abstract class MixinOfflinePlayerSkins extends Player{

    public MixinOfflinePlayerSkins(){
        super(null, null, 0, null);
    }

    @Shadow
    abstract PlayerInfo getPlayerListEntry();

    @ModifyReturnValue(
        method="getSkinTexture()Lnet/minecraft/util/Identifier;",
        at = @At("RETURN")
    )
    private ResourceLocation betterGetSkinTexture(ResourceLocation originalTexture){
        if(getPlayerListEntry() == null){
            return Minecraft.m_91087_().m_91109_().m_240306_(m_36316_());
        }
        return originalTexture;
    }

    // i guess ?
    @ModifyReturnValue(
        method="hasSkinTexture()Z",
        at = @At("RETURN")
    )
    private boolean betterCheckSkinTexture(boolean originalCheck){
        return true;
    }
}
