package com.samsthenerd.inline.api.client.renderers;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.vertex.PoseStack;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.client.GlowHandling;
import com.samsthenerd.inline.api.client.InlineRenderer;
import com.samsthenerd.inline.api.data.PlayerHeadData;
import com.samsthenerd.inline.api.data.SpriteInlineData;
import com.samsthenerd.inline.utils.FakeClientPlayerMaker;
import com.samsthenerd.inline.utils.TextureSprite;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.UUIDUtil;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class PlayerHeadRenderer implements InlineRenderer<PlayerHeadData>{

    public static final PlayerHeadRenderer INSTANCE = new PlayerHeadRenderer();

    @Override
    public ResourceLocation getId(){
        return new ResourceLocation(Inline.MOD_ID, "playerhead");
    }

    public ResourceLocation textureFromHeadData(PlayerHeadData data){
        GameProfile prof = FakeClientPlayerMaker.getBetterProfile(data.profile);
        ResourceLocation skinTextId;
        if(prof == null){
            // get a steve head i guess
            skinTextId = DefaultPlayerSkin.m_118627_(UUIDUtil.m_235875_(data.profile));
        } else {
            skinTextId = Minecraft.m_91087_().m_91109_().m_240306_(prof);
        }
        return skinTextId;
    }

    public SpriteInlineData getFace(PlayerHeadData data){
        TextureSprite faceSprite = TextureSprite.fromPixels(textureFromHeadData(data),
            8, 8, 8, 8, 64, 64);
        return new SpriteInlineData(faceSprite);
    }

    public SpriteInlineData getOuter(PlayerHeadData data){
        TextureSprite faceSprite = TextureSprite.fromPixels(textureFromHeadData(data),
            40, 8, 8, 8, 64, 64);
        return new SpriteInlineData(faceSprite);
    }

    @Override
    public int render(PlayerHeadData data, GuiGraphics context, int index, Style style, int codepoint, TextRenderingContext trContext){
        SpriteInlineData faceSpriteData = getFace(data);
        PoseStack matrices = context.m_280168_();
        matrices.m_85836_();
        matrices.m_85837_(0.25, 0.25, 0);
        matrices.m_85841_(8/(float)8.5, 8/(float)8.5,1);
        InlineSpriteRenderer.INSTANCE.render(faceSpriteData, context, index, style, codepoint, trContext);
        matrices.m_85849_();
        SpriteInlineData outerSpriteData = getOuter(data);
        matrices.m_85836_();
        matrices.m_252880_(0, 0, 10);
        int res = InlineSpriteRenderer.INSTANCE.render(outerSpriteData, context, index, style, codepoint, trContext);
        matrices.m_85849_();
        return res;
    }

    @Override
    public int charWidth(PlayerHeadData data, Style style, int codepoint){
        return 8;
    }

    @Override
    public GlowHandling getGlowPreference(PlayerHeadData forData){
        // silly but should be fine.
        if(forData.profile.getName() != null){
            return new GlowHandling.Full(forData.profile.getName().toLowerCase());
        }
        if(forData.profile.getId() != null){
            return new GlowHandling.Full(forData.profile.getId().toString().toLowerCase());
        }
        return new GlowHandling.Full();
    }
}
