package com.samsthenerd.inline.config;

import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.client.InlineClientAPI;
import com.samsthenerd.inline.api.matching.InlineMatcher;
import com.samsthenerd.inline.api.matching.MatcherInfo;

import com.samsthenerd.inline.xplat.IModMeta;
import com.samsthenerd.inline.xplat.IXPlatAbstractions;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.BooleanListEntry;
import me.shedaniel.clothconfig2.gui.entries.DoubleListEntry;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

/*
 * Should only run on client
 */
public class InlineConfigHandler {
    public static Screen getConfigScreen(Screen parent){
        // return AutoConfig.getConfigScreen(InlineAutoConfig.class, parent).get();

        InlineClientConfigImpl.getInstance().reloadFromFile(); // make sure we're up to date

        ConfigBuilder builder = ConfigBuilder.create()
            .setParentScreen(parent)
            .setTitle(Component.m_237115_("config.inline.title"));
        
        ConfigCategory matcherConfig = builder.getOrCreateCategory(Component.m_237115_("config.inline.category.matchers"));

        ConfigEntryBuilder entryBuilder = builder.entryBuilder();

        for(InlineMatcher matcher : InlineClientAPI.INSTANCE.getAllMatchers()){
            matcherConfig.addEntry(makeMatcherConfig(entryBuilder, matcher));
        }

        ConfigCategory extraFeatures = builder.getOrCreateCategory(Component.m_237115_("config.inline.category.extras"));

        BooleanListEntry modIconEntry = entryBuilder.startBooleanToggle(Component.m_237115_("config.inline.extras.modicon"), 
            InlineClientConfigImpl.getInstance().shouldRenderModIcons())
            .setTooltip(Component.m_237115_("config.inline.extras.modicon.desc"))
            .setDefaultValue(true)
            .setYesNoTextSupplier((boolval) -> boolval ? 
                Component.m_237115_("addServer.resourcePack.enabled").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)) : 
                Component.m_237115_("addServer.resourcePack.disabled").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED))
            )
            .setSaveConsumer((enabled) -> InlineClientConfigImpl.getInstance().setShouldRenderModIcons(enabled))
            .build();

        extraFeatures.addEntry(modIconEntry);

        DoubleListEntry chatCapField = entryBuilder.startDoubleField(Component.m_237115_("config.inline.extras.chatcap"),
                InlineClientConfigImpl.getInstance().maxChatSizeModifier())
                .setTooltip(Component.m_237115_("config.inline.extras.chatcap.desc"))
                .setDefaultValue(1.5).setMin(1.0).setMax(2.0)
                .setSaveConsumer((newCap) -> InlineClientConfigImpl.getInstance().setChatScaleCap(newCap))
                .build();
        extraFeatures.addEntry(chatCapField);

        if(IModMeta.getMod("create").isPresent()){
            BooleanListEntry createToggleEntry = entryBuilder.startBooleanToggle(Component.m_237115_("config.inline.extras.createinterop"),
                            InlineClientConfigImpl.getInstance().shouldDoCreateMixins())
                    .setTooltip(Component.m_237115_("config.inline.extras.createinterop.desc"))
                    .setDefaultValue(true)
                    .setYesNoTextSupplier((boolval) -> boolval ?
                            Component.m_237115_("addServer.resourcePack.enabled").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)) :
                            Component.m_237115_("addServer.resourcePack.disabled").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED))
                    )
                    .setSaveConsumer((enabled) -> InlineClientConfigImpl.getInstance().setShouldDoCreateMixins(enabled))
                    .build();
            extraFeatures.addEntry(createToggleEntry);
        }

        builder.setSavingRunnable(() -> InlineClientConfigImpl.getInstance().save());

        return builder.build();
    }

    private static AbstractConfigListEntry makeMatcherConfig(ConfigEntryBuilder entryBuilder, InlineMatcher matcher){
        MatcherInfo info = matcher.getInfo();
        // SubCategoryBuilder subBuilder = entryBuilder.startSubCategory(info.getTitle()).setExpanded(true);

        boolean matcherEnabled = InlineClientConfigImpl.getInstance().isMatcherEnabled(matcher.getId());
        return entryBuilder.startBooleanToggle(info.getTitle(matcherEnabled), matcherEnabled)
            .setTooltip(info.getDescription())
            .setDefaultValue(true)
            .setYesNoTextSupplier((boolval) -> boolval ? 
                Component.m_237115_("addServer.resourcePack.enabled").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GREEN)) : 
                Component.m_237115_("addServer.resourcePack.disabled").m_6270_(Style.f_131099_.m_131140_(ChatFormatting.RED))
            )
            .setSaveConsumer((enabled) -> InlineClientConfigImpl.getInstance().someableMatcher(matcher.getId(), enabled))
            .build();

    }
}
