/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.utils;

import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.mixin.core.NativeImageAccessor;
import com.samsthenerd.inline.utils.IntPair;
import com.samsthenerd.inline.utils.SpriteUVLens;
import com.samsthenerd.inline.utils.SpriteUVRegion;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import org.lwjgl.PointerBuffer;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class URLTextureUtils {
    private static final Map<ResourceLocation, ResourceLocation> LOADED_TEXTURES = Collections.synchronizedMap(new HashMap());
    private static final Map<ResourceLocation, Tuple<IntPair, SpriteUVLens>> TEXTURE_INFO = Collections.synchronizedMap(new HashMap());
    private static final Set<ResourceLocation> IN_PROGRESS_TEXTURES = Collections.synchronizedSet(new HashSet());

    @Nullable
    public static ResourceLocation loadTextureFromURL(String url, ResourceLocation textureId) {
        ResourceLocation maybeTexture = LOADED_TEXTURES.get(textureId);
        if (maybeTexture != null) {
            return maybeTexture;
        }
        if (IN_PROGRESS_TEXTURES.contains(textureId)) {
            return null;
        }
        IN_PROGRESS_TEXTURES.add(textureId);
        CompletableFuture.runAsync(() -> {
            try {
                URL textureUrl = new URL(url);
                URLConnection conn = textureUrl.openConnection();
                String contentType = conn.getContentType();
                if ("image/png".equals(contentType)) {
                    InputStream stream = conn.getInputStream();
                    NativeImage baseImage = NativeImage.m_85058_((InputStream)stream);
                    Minecraft.m_91087_().execute(() -> {
                        DynamicTexture texture = new DynamicTexture(baseImage);
                        Minecraft.m_91087_().m_91097_().m_118495_(textureId, (AbstractTexture)texture);
                        LOADED_TEXTURES.put(textureId, textureId);
                        TEXTURE_INFO.put(textureId, (Tuple<IntPair, SpriteUVLens>)new Tuple((Object)new IntPair(baseImage.m_84982_(), baseImage.m_85084_()), (Object)SpriteUVRegion.FULL.asLens()));
                        IN_PROGRESS_TEXTURES.remove(textureId);
                    });
                } else if ("image/gif".equals(contentType)) {
                    ByteBuffer byBuf = TextureUtil.readResource((InputStream)conn.getInputStream());
                    byBuf.rewind();
                    URLTextureUtils.readGif(textureId, byBuf);
                } else {
                    Inline.LOGGER.error("Unknown image type at url: " + url);
                }
            }
            catch (Exception e) {
                Inline.LOGGER.error("Failed to load texture from URL: " + url + "\n:" + e);
            }
        });
        return null;
    }

    @Nullable
    public static Tuple<IntPair, SpriteUVLens> getTextureInfo(ResourceLocation textureId) {
        return TEXTURE_INFO.get(textureId);
    }

    public static Tuple<IntPair, SpriteUVLens> readGif(ResourceLocation loc, ByteBuffer buf) throws IOException {
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            PointerBuffer delayBuf = memoryStack.mallocPointer(1);
            IntBuffer wBuf = memoryStack.mallocInt(1);
            IntBuffer hBuf = memoryStack.mallocInt(1);
            IntBuffer framesBuf = memoryStack.mallocInt(1);
            IntBuffer channelsBuf = memoryStack.mallocInt(1);
            ByteBuffer imageBuf = STBImage.stbi_load_gif_from_memory((ByteBuffer)buf, (PointerBuffer)delayBuf, (IntBuffer)wBuf, (IntBuffer)hBuf, (IntBuffer)framesBuf, (IntBuffer)channelsBuf, (int)4);
            if (imageBuf == null) {
                throw new IOException("Could not load image here: " + STBImage.stbi_failure_reason());
            }
            NativeImage image = new NativeImage(wBuf.get(0), hBuf.get(0) * framesBuf.get(0), true);
            MemoryUtil.memCopy((long)MemoryUtil.memAddress((ByteBuffer)imageBuf), (long)((NativeImageAccessor)image).getPointer(), (long)((long)wBuf.get(0) * (long)hBuf.get(0) * (long)framesBuf.get(0) * 4L));
            DynamicTexture tex = new DynamicTexture(image);
            int[] delays = new int[framesBuf.get(0)];
            delayBuf.getIntBuffer(framesBuf.get(0)).get(delays);
            Tuple textInfo = new Tuple((Object)new IntPair(wBuf.get(0), hBuf.get(0) * framesBuf.get(0)), (Object)new SpriteUVLens.AnimUVLens(1.0 / (double)framesBuf.get(0), true, delays));
            Minecraft.m_91087_().execute(() -> {
                Minecraft.m_91087_().m_91097_().m_118495_(loc, (AbstractTexture)tex);
                LOADED_TEXTURES.put(loc, loc);
                TEXTURE_INFO.put(loc, (Tuple<IntPair, SpriteUVLens>)textInfo);
                IN_PROGRESS_TEXTURES.remove(loc);
            });
            Tuple tuple = textInfo;
            return tuple;
        }
    }
}

