package com.samsthenerd.inline.utils.cradles;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.utils.EntityCradle;
import java.util.HashMap;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

/**
 * An entity cradle backed by an EntityType identifier.
 */
public class EntTypeCradle<E extends Entity> extends EntityCradle {

    private static final HashMap<ResourceLocation, Entity> ENTITY_CACHE = new HashMap<>();

    private final EntityType<E> type;

    @Override
    public String getId(){
        return type.m_20675_();
    }

    public EntTypeCradle(EntityType<E> type){
        this.type = type;
    }

    public static Optional<EntTypeCradle> fromTypeId(ResourceLocation id){
        return EntityType.m_20632_(id.toString()).map(EntTypeCradle::new);
    }

    public EntityType<E> getEntType(){
        return type;
    }

    public CradleType<?> getType(){
        return EntTypeCradleType.INSTANCE;
    }

    public Entity getEntity(Level world){
        ResourceLocation typeId = EntityType.m_20613_(type);
        if(ENTITY_CACHE.containsKey(typeId)){
            return ENTITY_CACHE.get(typeId);
        }

        try{
            Entity newEnt = type.m_20615_(world);
            ENTITY_CACHE.put(typeId, newEnt);
            return newEnt;
        } catch (Exception e){
            return null;
        }

    }

    private static class EntTypeCradleType implements CradleType<EntTypeCradle>{

        public static EntTypeCradleType INSTANCE = EntityCradle.addCradleType(new EntTypeCradleType());

        public ResourceLocation getId(){
            return new ResourceLocation(Inline.MOD_ID, "enttype");
        }

        public Codec<EntTypeCradle> getCodec(){
            return ResourceLocation.f_135803_.comapFlatMap(
                (id) -> EntTypeCradle.fromTypeId(id).map(DataResult::success).orElse(DataResult.error(() -> "no entity type: " + id.toString())),
                (cradle) -> EntityType.m_20613_(cradle.getEntType())
            );
        }
    }
}
