package com.samsthenerd.inline.forge;

import java.util.Map.Entry;
import java.util.function.Function;

import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.registry.InlineTooltips;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class InlineForgeClient {
    @SubscribeEvent
    public static void registerTooltipComponents(RegisterClientTooltipComponentFactoriesEvent evt) {
        Inline.logPrint("registering tooltip components");
        // evt.register(MirrorTooltipData.class, MirrorTooltipComponent::new);
        InlineTooltips.init();
        for(Entry<Class<? extends TooltipComponent>, Function<TooltipComponent, ClientTooltipComponent>> entry : InlineTooltips.tooltipDataToComponent.entrySet()){
            evt.register(entry.getKey(), entry.getValue());
        }
    }
}

