package com.samsthenerd.inline.api.data;


import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Codec;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.tooltips.CustomTooltipManager;
import com.samsthenerd.inline.tooltips.providers.EntityTTProvider;
import com.samsthenerd.inline.utils.cradles.PlayerCradle;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;

public class PlayerHeadData implements InlineData<PlayerHeadData>{

    @Override
    public PlayerHeadDataType getType(){
        return PlayerHeadDataType.INSTANCE;
    }

    @Override
    public ResourceLocation getRendererId(){
        return new ResourceLocation(Inline.MOD_ID, "playerhead");
    }

    public final GameProfile profile;

    public PlayerHeadData(GameProfile profile){
        this.profile = profile;
    }

    public HoverEvent getEntityDisplayHoverEvent(){
        return new HoverEvent(
            HoverEvent.Action.f_130832_, 
            new HoverEvent.ItemStackInfo(CustomTooltipManager.getForTooltip(EntityTTProvider.INSTANCE, new PlayerCradle(profile)))
        ); 
    }

    public Style getDataStyle(boolean withAdditional){
        Style superStyle = InlineData.super.asStyle(withAdditional);
        if(!withAdditional) return superStyle;
        return superStyle.m_131146_(Style.f_131099_.m_131144_(getEntityDisplayHoverEvent()));
    }

    public static class PlayerHeadDataType implements InlineDataType<PlayerHeadData> {
        public static PlayerHeadDataType INSTANCE = new PlayerHeadDataType();

        @Override
        public ResourceLocation getId(){
            return new ResourceLocation(Inline.MOD_ID, "playerhead");
        }

        private static Gson GSON = new GsonBuilder().create();

        @Override
        public Codec<PlayerHeadData> getCodec(){
            return PlayerCradle.GAME_PROFILE_CODEC.xmap(PlayerHeadData::new, data -> data.profile);
        }

        public PlayerHeadData deserialize(JsonElement json){
            return new PlayerHeadData(GSON.fromJson(json, GameProfile.class));
        }

        public JsonElement serializeData(PlayerHeadData data){
            GameProfile profile = ((PlayerHeadData)data).profile;
            return GSON.toJsonTree(profile);
        }
    }
}
