package com.samsthenerd.inline.api.client.renderers;

import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.api.client.GlowHandling;
import com.samsthenerd.inline.api.client.InlineRenderer;
import com.samsthenerd.inline.api.data.ItemInlineData;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class InlineErrorRenderer implements InlineRenderer{

    public static final InlineErrorRenderer INSTANCE = new InlineErrorRenderer();
    public static final ItemInlineData ERROR_DATA = new ItemInlineData(new ItemStack(Items.f_42127_));

    @Override
    public ResourceLocation getId(){
        return new ResourceLocation(Inline.MOD_ID, "error");
    }

    @Override
    public int render(InlineData data, GuiGraphics context, int index, Style style, int codepoint, TextRenderingContext trContext){
        return InlineItemRenderer.INSTANCE.render(ERROR_DATA, context, index, style, codepoint, trContext);
    }

    @Override
    public int charWidth(InlineData data, Style style, int codepoint){
        return InlineItemRenderer.INSTANCE.charWidth(ERROR_DATA, style, codepoint);
    }

    @Override
    public GlowHandling getGlowPreference(InlineData data) { return InlineItemRenderer.INSTANCE.getGlowPreference(ERROR_DATA); }
}
