/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.api.matching;

import com.samsthenerd.inline.api.InlineData;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSink;

public interface InlineMatch {
    public int accept(FormattedCharSink var1, int var2, Style var3);

    public int charLength();

    public static class TextMatch
    implements InlineMatch {
        private Component text;

        public TextMatch(Component text) {
            this.text = text;
        }

        @Override
        public int accept(FormattedCharSink visitor, int index, Style currentStyle) {
            if (this.text.getString().equals("")) {
                return 1;
            }
            AtomicInteger offset = new AtomicInteger(0);
            this.text.m_7451_((style, str) -> {
                for (char c : str.toCharArray()) {
                    visitor.m_6411_(index + offset.get(), style.m_131146_(currentStyle), (int)c);
                    offset.incrementAndGet();
                }
                return Optional.empty();
            }, currentStyle);
            return offset.get();
        }

        @Override
        public int charLength() {
            return Math.max(this.text.getString().length(), 1);
        }
    }

    public static class DataMatch
    implements InlineMatch {
        public final InlineData data;
        public final Style style;

        public DataMatch(InlineData data, Style style) {
            this.data = data;
            this.style = style;
        }

        public DataMatch(InlineData data) {
            this(data, Style.f_131099_);
        }

        @Override
        public int accept(FormattedCharSink visitor, int index, Style currentStyle) {
            Style nonDataStyle = this.style.m_131146_(currentStyle);
            Style dataStyle = nonDataStyle.withInlineData(this.data);
            visitor.m_6411_(index, dataStyle, 46);
            return 1;
        }

        @Override
        public int charLength() {
            return 1;
        }
    }
}

