package com.samsthenerd.inline.tooltips.components;

import java.util.function.BiFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.samsthenerd.inline.tooltips.data.EntityDisplayTTData;
import com.samsthenerd.inline.utils.EntityCradle;

public class EntityDisplayTTComp implements ClientTooltipComponent {
    public static final float DEFAULT_RENDER_SIZE = 96f;

    private EntityCradle cradle;
    private BiFunction<Integer, Integer, Integer> widthProvider;

    public EntityDisplayTTComp(EntityDisplayTTData tt) {
        this.cradle = tt.cradle;
        this.widthProvider = tt.widthProvider;
    }

    @Override
    public void m_183452_(Font font, int mouseX, int mouseY, GuiGraphics context) {
        // reload it just incase it failed the first time or whatever ?
        Entity ent = cradle.getEntity(Minecraft.m_91087_().f_91073_);
        if(ent == null) return;

        AABB bounds = ent.m_20191_().m_82377_(0, 0.05, 0);

        double height = bounds.m_82376_();

        float rot = 15f;

        EntityRenderer renderer = Minecraft.m_91087_().m_91290_().m_114382_(ent);
        PoseStack matrices = context.m_280168_();
        matrices.m_85836_();
        int rHeight = getRenderHeight();
        int ttWidth = m_142069_(font);
        matrices.m_85837_(mouseX + ttWidth/2.0, mouseY, 500);
        float scaleFactor = (float)(rHeight/height);
        matrices.m_85841_(scaleFactor, -scaleFactor, scaleFactor);
        matrices.m_85837_(0, -height, 0);
        Minecraft client = Minecraft.m_91087_();
        float tickDelta = client.m_91296_();
        // float rotation = 90f * (Util.getMeasuringTimeMs() / 1000f + data.getUniqueOffset());
        matrices.m_252781_(Axis.f_252436_.m_252977_(rot));
        renderer.m_7392_(ent, 0, 0, matrices, context.m_280091_(), LightTexture.f_173040_);
        matrices.m_85849_();
    }

    @Override
    public int m_142069_(Font pFont) {
        Entity ent = cradle.getEntity(Minecraft.m_91087_().f_91073_);
        if(ent == null) return 0;

        // Box bounds = ent.getBoundingBox().expand(0.15, 0.1, 0.15);
        AABB bounds = ent.m_20191_().m_82377_(0, 0.05, 0);

        double width = bounds.m_82362_();
        double depth = bounds.m_82385_();
        double height = bounds.m_82376_();

        float rot = 15f;
        double radRot = Math.toRadians(rot % 90);
        double pWidth = (width * Math.cos(radRot)) + (depth * Math.sin(radRot));

        return (int) (widthProvider.apply(
            (int) (pWidth*100),
            (int) (height*100)
        )) + 16;
    }

    private int getRenderHeight(){
        Entity ent = cradle.getEntity(Minecraft.m_91087_().f_91073_);
        if(ent == null) return 0;

        AABB bounds = ent.m_20191_().m_82377_(0, 0.05, 0);

        double width = bounds.m_82362_();
        double depth = bounds.m_82385_();
        double height = bounds.m_82376_();

        float rot = 15f;
        double radRot = Math.toRadians(rot % 90);
        double pWidth = (width * Math.cos(radRot)) + (depth * Math.sin(radRot));

        int realWidth = widthProvider.apply(
            (int) (pWidth*100),
            (int) (height*100)
        );
        if(pWidth == 0){
            return 0;
        }
        return (int)(realWidth * (height / pWidth));
    }

    @Override
    public int m_142103_() {
        return getRenderHeight() + 4; 
    }
}
